/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public final class TransparentItemRenderHelper {
    private static final RenderType TRANSLUCENT = RenderType.entityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);

    private TransparentItemRenderHelper() {
    }

    public static void renderItemWithAlpha(PoseStack poseStack, ItemStack stack, int x, int y, int alpha) {
        if (stack.isEmpty()) {
            return;
        }
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = renderer.getModel(stack, null, (LivingEntity)Minecraft.getInstance().player, 0);
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 50.0);
        TransparentItemRenderHelper.renderItemModelWithAlpha(poseStack, stack, x, y, alpha, model, renderer);
        poseStack.popPose();
    }

    public static void renderItemModelWithAlpha(PoseStack poseStack, ItemStack stack, int x, int y, int alpha, BakedModel model, ItemRenderer renderer) {
        boolean flatLight;
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelViewStack = poseStack;
        modelViewStack.pushPose();
        modelViewStack.translate((float)x, (float)y, 100.0f);
        modelViewStack.translate(8.0, 8.0, 0.0);
        modelViewStack.scale(1.0f, -1.0f, 1.0f);
        modelViewStack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        boolean bl = flatLight = !model.usesBlockLight();
        if (flatLight) {
            Lighting.setupForFlatItems();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        renderer.render(stack, ItemDisplayContext.GUI, false, new PoseStack(), TransparentItemRenderHelper.wrapBuffer((MultiBufferSource)buffer, alpha, alpha < 255), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        buffer.endBatch();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.setupFor3DItems();
        }
        modelViewStack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    private static MultiBufferSource wrapBuffer(MultiBufferSource buffer, int alpha, boolean forceTranslucent) {
        return renderType -> new GhostVertexConsumer(buffer.getBuffer(forceTranslucent ? TRANSLUCENT : renderType), alpha);
    }

    public record GhostVertexConsumer(VertexConsumer wrapped, int alpha) implements VertexConsumer
    {
        public VertexConsumer addVertex(float x, float y, float z) {
            return this.wrapped.addVertex(x, y, z);
        }

        public VertexConsumer setColor(int red, int green, int blue, int alpha) {
            return this.wrapped.setColor(red, green, blue, alpha * this.alpha / 255);
        }

        public VertexConsumer setUv(float u, float v) {
            return this.wrapped.setUv(u, v);
        }

        public VertexConsumer setOverlay(int u) {
            return this.wrapped.setOverlay(u);
        }

        public VertexConsumer setUv2(int u, int v) {
            return this.wrapped.setUv2(u, v);
        }

        public VertexConsumer setNormal(float x, float y, float z) {
            return this.wrapped.setNormal(x, y, z);
        }

        public VertexConsumer setUv1(int i, int i1) {
            return this.wrapped.setUv1(i, i1);
        }

        public void addVertex(float pX, float pY, float pZ, int pColor, float pU, float pV, int pPackedOverlay, int pPackedLight, float pNormalX, float pNormalY, float pNormalZ) {
            this.wrapped.addVertex(pX, pY, pZ, pColor, pU, pV, pPackedOverlay, pPackedLight, pNormalX, pNormalY, pNormalZ);
        }

        public VertexConsumer setColor(float pRed, float pGreen, float pBlue, float pAlpha) {
            return this.wrapped.setColor(pRed, pGreen, pBlue, pAlpha);
        }

        public VertexConsumer setColor(int pColor) {
            return this.wrapped.setColor(pColor);
        }

        public VertexConsumer setWhiteAlpha(int pAlpha) {
            return this.wrapped.setWhiteAlpha(pAlpha);
        }

        public VertexConsumer setLight(int pPackedLight) {
            return this.wrapped.setLight(pPackedLight);
        }

        public void putBulkData(PoseStack.Pose pPose, BakedQuad pQuad, float pRed, float pGreen, float pBlue, float pAlpha, int pPackedLight, int pPackedOverlay) {
            this.wrapped.putBulkData(pPose, pQuad, pRed, pGreen, pBlue, pAlpha, pPackedLight, pPackedOverlay);
        }

        public void putBulkData(PoseStack.Pose pPose, BakedQuad pQuad, float[] pBrightness, float pRed, float pGreen, float pBlue, float pAlpha, int[] pLightmap, int pPackedOverlay, boolean p_331268_) {
            this.wrapped.putBulkData(pPose, pQuad, pBrightness, pRed, pGreen, pBlue, pAlpha, pLightmap, pPackedOverlay, p_331268_);
        }

        public VertexConsumer addVertex(Vector3f pPos) {
            return this.wrapped.addVertex(pPos);
        }

        public VertexConsumer addVertex(PoseStack.Pose pPose, Vector3f pPos) {
            return this.wrapped.addVertex(pPose, pPos);
        }

        public VertexConsumer addVertex(PoseStack.Pose pPose, float pX, float pY, float pZ) {
            return this.wrapped.addVertex(pPose, pX, pY, pZ);
        }

        public VertexConsumer addVertex(Matrix4f pPose, float pX, float pY, float pZ) {
            return this.wrapped.addVertex(pPose, pX, pY, pZ);
        }

        public VertexConsumer setNormal(PoseStack.Pose pPose, float pNormalX, float pNormalY, float pNormalZ) {
            return this.wrapped.setNormal(pPose, pNormalX, pNormalY, pNormalZ);
        }
    }
}

