/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mcjty.lib.crafting.IRecipeBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public abstract class BaseRecipeProvider
extends RecipeProvider {
    private final Map<Character, Ingredient> defaultIngredients = new HashMap<Character, Ingredient>();
    private String group = "";

    protected BaseRecipeProvider group(String group) {
        this.group = group;
        return this;
    }

    protected BaseRecipeProvider add(char c, TagKey<Item> itemTag) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.of(itemTag));
        return this;
    }

    protected BaseRecipeProvider add(char c, ItemLike itemProvider) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.of((ItemLike[])new ItemLike[]{itemProvider}));
        return this;
    }

    protected BaseRecipeProvider add(char c, Ingredient ingredient) {
        this.defaultIngredients.put(Character.valueOf(c), ingredient);
        return this;
    }

    private void buildIntern(RecipeOutput consumer, Consumer<String> lineConsumer, BiConsumer<Character, Ingredient> ingredientConsumer, String ... lines) {
        HashSet characters = new HashSet();
        for (String line : lines) {
            lineConsumer.accept(line);
            line.chars().forEach(value -> characters.add(Character.valueOf((char)value)));
        }
        for (Character c : characters) {
            if (!this.defaultIngredients.containsKey(c)) continue;
            ingredientConsumer.accept(c, this.defaultIngredients.get(c));
        }
    }

    protected void build(RecipeOutput consumer, IRecipeBuilder<?> builder, String ... lines) {
        this.buildIntern(consumer, builder::patternLine, builder::define, lines);
        builder.setGroup(this.group).build(consumer);
    }

    protected void build(RecipeOutput consumer, ShapedRecipeBuilder builder, String ... lines) {
        this.buildIntern(consumer, arg_0 -> ((ShapedRecipeBuilder)builder).pattern(arg_0), (arg_0, arg_1) -> ((ShapedRecipeBuilder)builder).define(arg_0, arg_1), lines);
        builder.group(this.group).save(consumer);
    }

    protected void build(RecipeOutput consumer, ShapelessRecipeBuilder builder) {
        builder.group(this.group).save(consumer);
    }

    protected void build(RecipeOutput consumer, ResourceLocation id, ShapelessRecipeBuilder builder) {
        builder.group(this.group).save(consumer, id);
    }

    protected void build(RecipeOutput consumer, ResourceLocation id, IRecipeBuilder<?> builder, String ... lines) {
        this.buildIntern(consumer, builder::patternLine, builder::define, lines);
        builder.setGroup(this.group).build(consumer, id);
    }

    protected void build(RecipeOutput consumer, ResourceLocation id, ShapedRecipeBuilder builder, String ... lines) {
        this.buildIntern(consumer, arg_0 -> ((ShapedRecipeBuilder)builder).pattern(arg_0), (arg_0, arg_1) -> ((ShapedRecipeBuilder)builder).define(arg_0, arg_1), lines);
        builder.group(this.group).save(consumer, id);
    }

    public BaseRecipeProvider(DataGenerator datagen, CompletableFuture<HolderLookup.Provider> provider) {
        super(datagen.getPackOutput(), provider);
        this.add('d', (ItemLike)Items.DIAMOND);
        this.add('e', (ItemLike)Items.EMERALD);
        this.add('o', (TagKey<Item>)Tags.Items.ENDER_PEARLS);
        this.add('r', (ItemLike)Items.REDSTONE);
        this.add('R', (ItemLike)Items.REDSTONE_BLOCK);
        this.add('i', (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.add('p', (ItemLike)Items.PAPER);
        this.add('c', (TagKey<Item>)ItemTags.COALS);
        this.add('B', (ItemLike)Blocks.BRICKS);
        this.add('W', (ItemLike)Items.WATER_BUCKET);
        this.add('L', (ItemLike)Items.LAVA_BUCKET);
        this.add('b', (ItemLike)Items.BUCKET);
        this.add('T', (ItemLike)Items.REDSTONE_TORCH);
        this.add('D', (ItemLike)Blocks.DIRT);
        this.add('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS);
        this.add('O', (ItemLike)Blocks.OBSIDIAN);
    }
}

