/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.Optional;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketDataFromServer(BlockPos pos, String command, TypedMap result) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mcjtylib", (String)"datafromserver");
    public static final CustomPacketPayload.Type<PacketDataFromServer> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketDataFromServer> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs::optional), s -> Optional.ofNullable(s.pos), (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketDataFromServer::command, TypedMap.STREAM_CODEC, PacketDataFromServer::result, (pos, command, result) -> new PacketDataFromServer(pos.orElse(null), (String)command, (TypedMap)result));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            GenericTileEntity generic;
            BlockEntity te;
            if (this.pos == null) {
                GenericContainer container = PacketDataFromServer.getOpenContainer();
                if (container == null) {
                    Logging.log("Container is missing!");
                    return;
                }
                te = container.getBe();
            } else {
                te = SafeClientTools.getClientWorld().getBlockEntity(this.pos);
            }
            if (te instanceof GenericTileEntity && (generic = (GenericTileEntity)te).executeClientCommand(this.command, SafeClientTools.getClientPlayer(), this.result)) {
                return;
            }
            Logging.log("Command " + this.command + " was not handled!");
        });
    }

    private static GenericContainer getOpenContainer() {
        AbstractContainerMenu container = SafeClientTools.getClientPlayer().containerMenu;
        if (container instanceof GenericContainer) {
            return (GenericContainer)container;
        }
        return null;
    }
}

