/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.block;

import com.mebeamformer.blockentity.WirelessEnergyTowerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WirelessEnergyTowerBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty PART = IntegerProperty.create((String)"part", (int)0, (int)2);

    public WirelessEnergyTowerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PART, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART});
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (pos.getY() < level.getMaxBuildHeight() - 2 && level.getBlockState(pos.above()).canBeReplaced(context) && level.getBlockState(pos.above(2)).canBeReplaced(context)) {
            return (BlockState)this.defaultBlockState().setValue((Property)PART, (Comparable)Integer.valueOf(0));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue((Property)PART, (Comparable)Integer.valueOf(1)), 3);
        level.setBlock(pos.above(2), (BlockState)state.setValue((Property)PART, (Comparable)Integer.valueOf(2)), 3);
        if (!level.isClientSide() && (Integer)state.getValue((Property)PART) == 0) {
            level.blockUpdated(pos, (Block)this);
            for (Direction dir : Direction.values()) {
                level.updateNeighborsAt(pos.relative(dir), (Block)this);
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            int part = (Integer)state.getValue((Property)PART);
            if (part == 0) {
                if (level.getBlockState(pos.above()).is((Block)this)) {
                    level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 35);
                }
                if (level.getBlockState(pos.above(2)).is((Block)this)) {
                    level.setBlock(pos.above(2), Blocks.AIR.defaultBlockState(), 35);
                }
            } else if (part == 1) {
                if (level.getBlockState(pos.below()).is((Block)this)) {
                    level.setBlock(pos.below(), Blocks.AIR.defaultBlockState(), 35);
                }
                if (level.getBlockState(pos.above()).is((Block)this)) {
                    level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 35);
                }
            } else if (part == 2) {
                if (level.getBlockState(pos.below()).is((Block)this)) {
                    level.setBlock(pos.below(), Blocks.AIR.defaultBlockState(), 35);
                }
                if (level.getBlockState(pos.below(2)).is((Block)this)) {
                    level.setBlock(pos.below(2), Blocks.AIR.defaultBlockState(), 35);
                }
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        int part = (Integer)state.getValue((Property)PART);
        if (direction.getAxis() == Direction.Axis.Y) {
            if (part == 0 && direction == Direction.UP) {
                if (!neighborState.is((Block)this) || (Integer)neighborState.getValue((Property)PART) != 1) {
                    return Blocks.AIR.defaultBlockState();
                }
            } else if (part == 1) {
                if (!(direction != Direction.DOWN || neighborState.is((Block)this) && (Integer)neighborState.getValue((Property)PART) == 0)) {
                    return Blocks.AIR.defaultBlockState();
                }
                if (!(direction != Direction.UP || neighborState.is((Block)this) && (Integer)neighborState.getValue((Property)PART) == 2)) {
                    return Blocks.AIR.defaultBlockState();
                }
            } else if (!(part != 2 || direction != Direction.DOWN || neighborState.is((Block)this) && (Integer)neighborState.getValue((Property)PART) == 1)) {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)PART) == 0) {
            return new WirelessEnergyTowerBlockEntity(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return null;
    }
}

