/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.blockentity;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.orientation.BlockOrientation;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import com.mebeamformer.MEBeamFormer;
import com.mebeamformer.block.BeamFormerBlock;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BeamFormerBlockEntity
extends AENetworkedBlockEntity {
    private int beamLength = 0;
    private IGridConnection connection = null;
    private boolean hideBeam = false;
    private Direction lastExposedBack = null;

    public BeamFormerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MEBeamFormer.BEAM_FORMER_BE.get(), pos, state);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
    }

    public AECableType getCableConnectionType(Direction dir) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BeamFormerBlock.FACING);
        if (dir == facing.getOpposite()) {
            return AECableType.SMART;
        }
        return AECableType.NONE;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BeamFormerBlock.FACING);
        return EnumSet.of(facing.getOpposite());
    }

    public int getBeamLength() {
        return this.beamLength;
    }

    public boolean isHideBeam() {
        return this.hideBeam;
    }

    public boolean shouldRenderBeam() {
        return !this.hideBeam && this.beamLength > 0;
    }

    public void toggleBeamVisibility() {
        boolean bl = this.hideBeam = !this.hideBeam;
        if (this.connection != null) {
            try {
                Object owner;
                IGridNode otherNode;
                IGridNode myNode = this.getMainNode().getNode();
                if (myNode != null && (otherNode = this.connection.getOtherSide(myNode)) != null && (owner = otherNode.getOwner()) instanceof BeamFormerBlockEntity) {
                    BeamFormerBlockEntity other = (BeamFormerBlockEntity)((Object)owner);
                    other.hideBeam = this.hideBeam;
                    other.markForUpdate();
                    other.setChanged();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.markForUpdate();
        this.setChanged();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BeamFormerBlockEntity be) {
        IManagedGridNode mainNode;
        IGridNode aNode;
        if (be.isRemoved()) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)BeamFormerBlock.FACING);
        Direction back = facing.getOpposite();
        if (be.lastExposedBack != back) {
            be.getMainNode().setExposedOnSides(EnumSet.of(back));
            be.lastExposedBack = back;
        }
        IGridNode iGridNode = aNode = (mainNode = be.getMainNode()) == null ? null : mainNode.getNode();
        if (aNode == null) {
            int old = be.beamLength;
            be.beamLength = 0;
            if (!be.isRemoved() && state.getValue(BeamFormerBlock.STATUS) != BeamFormerBlock.Status.ON) {
                level.setBlock(pos, (BlockState)state.setValue(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.ON)), 3);
            }
            if (old != 0) {
                be.markForUpdate();
            }
            return;
        }
        BlockPos cur = pos;
        int max = 32;
        int len = 0;
        BeamFormerBlockEntity target = null;
        for (int i = 0; i < max; ++i) {
            Direction otherFacing;
            BeamFormerBlockEntity other;
            BlockState bs = level.getBlockState(cur = cur.relative(facing));
            if (bs.canOcclude() && !bs.isAir()) {
                BlockEntity obe = level.getBlockEntity(cur);
                if (!(obe instanceof BeamFormerBlockEntity)) break;
                other = (BeamFormerBlockEntity)obe;
                otherFacing = (Direction)level.getBlockState(cur).getValue((Property)BeamFormerBlock.FACING);
                if (otherFacing != facing.getOpposite()) break;
                target = other;
                len = i;
                break;
            }
            len = i + 1;
            BlockEntity pbe = level.getBlockEntity(cur);
            if (!(pbe instanceof BeamFormerBlockEntity)) continue;
            other = (BeamFormerBlockEntity)pbe;
            otherFacing = (Direction)level.getBlockState(cur).getValue((Property)BeamFormerBlock.FACING);
            if (otherFacing == facing) {
                target = null;
                break;
            }
            if (otherFacing != facing.getOpposite()) continue;
            target = other;
            break;
        }
        if (target != null) {
            IGridNode tNode;
            IManagedGridNode tManaged = target.getMainNode();
            IGridNode iGridNode2 = tNode = tManaged == null ? null : tManaged.getNode();
            if (tNode != null) {
                boolean bOk;
                be.tryConnect(target, len);
                IManagedGridNode aManaged = be.getMainNode();
                boolean aOk = aManaged != null && aManaged.isOnline() && aManaged.isPowered();
                boolean bl = bOk = tManaged.isOnline() && tManaged.isPowered();
                if (aOk && bOk) {
                    if (!be.isRemoved() && state.getValue(BeamFormerBlock.STATUS) != BeamFormerBlock.Status.BEAMING) {
                        level.setBlock(pos, (BlockState)state.setValue(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.BEAMING)), 3);
                    }
                } else {
                    int oldA = be.beamLength;
                    be.beamLength = 0;
                    if (!be.isRemoved() && state.getValue(BeamFormerBlock.STATUS) != BeamFormerBlock.Status.ON) {
                        level.setBlock(pos, (BlockState)state.setValue(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.ON)), 3);
                    }
                    if (oldA != 0) {
                        be.markForUpdate();
                    }
                    BlockState tState = target.getBlockState();
                    int oldB = target.beamLength;
                    target.beamLength = 0;
                    if (!target.isRemoved() && tState.getValue(BeamFormerBlock.STATUS) != BeamFormerBlock.Status.ON) {
                        level.setBlock(target.getBlockPos(), (BlockState)tState.setValue(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.ON)), 3);
                    }
                    if (oldB != 0) {
                        target.markForUpdate();
                    }
                }
            }
        } else {
            int old = be.beamLength;
            be.disconnect();
            if (!be.isRemoved() && state.getValue(BeamFormerBlock.STATUS) != BeamFormerBlock.Status.ON) {
                level.setBlock(pos, (BlockState)state.setValue(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.ON)), 3);
            }
            be.beamLength = 0;
            if (old != 0) {
                be.markForUpdate();
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BeamFormerBlockEntity be) {
    }

    private void tryConnect(BeamFormerBlockEntity target, int len) {
        IGridConnection existing;
        block13: {
            IManagedGridNode a = this.getMainNode();
            IManagedGridNode b = target.getMainNode();
            if (a == null || b == null) {
                return;
            }
            IGridNode aNode = a.getNode();
            IGridNode bNode = b.getNode();
            if (aNode == null || bNode == null) {
                return;
            }
            if (this.connection != null) {
                IGridNode other = this.connection.getOtherSide(aNode);
                if (other == bNode) {
                    int oldA = this.beamLength;
                    int oldB = target.beamLength;
                    this.beamLength = len;
                    target.beamLength = len;
                    if (target.connection == null) {
                        target.connection = this.connection;
                    }
                    if (this.level != null && oldA != this.beamLength) {
                        this.markForUpdate();
                    }
                    if (target.level != null && oldB != target.beamLength) {
                        target.markForUpdate();
                    }
                    return;
                }
                this.disconnect();
            }
            if ((existing = (IGridConnection)aNode.getConnections().stream().filter(c -> c.getOtherSide(aNode) == bNode).findFirst().orElse(null)) == null) {
                try {
                    existing = GridHelper.createConnection((IGridNode)aNode, (IGridNode)bNode);
                }
                catch (IllegalStateException ignored) {
                    existing = aNode.getConnections().stream().filter(c -> c.getOtherSide(aNode) == bNode).findFirst().orElse(null);
                    if (existing != null) break block13;
                    int oldA = this.beamLength;
                    this.beamLength = len;
                    if (this.level != null && oldA != this.beamLength) {
                        this.markForUpdate();
                    }
                    return;
                }
            }
        }
        this.connection = existing;
        target.connection = existing;
        int oldA = this.beamLength;
        int oldB = target.beamLength;
        this.beamLength = len;
        target.beamLength = len;
        if (this.level != null && oldA != this.beamLength) {
            this.markForUpdate();
        }
        if (target.level != null && oldB != target.beamLength) {
            target.markForUpdate();
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                Object owner;
                IGridNode otherNode;
                IGridNode myNode = this.getMainNode().getNode();
                if (myNode != null && (otherNode = this.connection.getOtherSide(myNode)) != null && (owner = otherNode.getOwner()) instanceof BeamFormerBlockEntity) {
                    BeamFormerBlockEntity otherBe = (BeamFormerBlockEntity)((Object)owner);
                    int old = otherBe.beamLength;
                    otherBe.beamLength = 0;
                    if (otherBe.level != null && old != 0) {
                        otherBe.markForUpdate();
                    }
                    BlockState st = otherBe.getBlockState();
                    if (!otherBe.isRemoved() && st.getValue(BeamFormerBlock.STATUS) == BeamFormerBlock.Status.BEAMING) {
                        otherBe.level.setBlock(otherBe.getBlockPos(), (BlockState)st.setValue(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.ON)), 3);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection.destroy();
            this.connection = null;
        }
    }

    protected void writeToStream(RegistryFriendlyByteBuf data) {
        data.writeVarInt(this.beamLength);
        data.writeBoolean(this.hideBeam);
    }

    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        int oldLength = this.beamLength;
        boolean oldHide = this.hideBeam;
        this.beamLength = data.readVarInt();
        this.hideBeam = data.readBoolean();
        return oldLength != this.beamLength || oldHide != this.hideBeam;
    }

    public void onChunkUnloaded() {
        this.disconnect();
        super.onChunkUnloaded();
    }

    public void setRemoved() {
        super.setRemoved();
        this.disconnect();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("hideBeam", this.hideBeam);
    }

    public void loadTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadTag(tag, registries);
        this.hideBeam = tag.getBoolean("hideBeam");
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.getBlockPos();
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof BeamFormerBlock)) {
            return new AABB((double)(pos.getX() - 5), (double)(pos.getY() - 5), (double)(pos.getZ() - 5), (double)(pos.getX() + 6), (double)(pos.getY() + 6), (double)(pos.getZ() + 6));
        }
        Direction dir = (Direction)state.getValue((Property)BeamFormerBlock.FACING);
        int len = Math.max(0, this.beamLength);
        if (len <= 0) {
            return new AABB((double)(pos.getX() - 5), (double)(pos.getY() - 5), (double)(pos.getZ() - 5), (double)(pos.getX() + 6), (double)(pos.getY() + 6), (double)(pos.getZ() + 6));
        }
        BlockPos endPos = pos.relative(dir, len);
        double minX = Math.min(pos.getX(), endPos.getX());
        double minY = Math.min(pos.getY(), endPos.getY());
        double minZ = Math.min(pos.getZ(), endPos.getZ());
        double maxX = Math.max(pos.getX() + 1, endPos.getX() + 1);
        double maxY = Math.max(pos.getY() + 1, endPos.getY() + 1);
        double maxZ = Math.max(pos.getZ() + 1, endPos.getZ() + 1);
        double expansion = 2.0;
        return new AABB(minX - expansion, minY - expansion, minZ - expansion, maxX + expansion, maxY + expansion, maxZ + expansion);
    }
}

