/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.energy;

import com.mebeamformer.energy.GTEnergyAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyStorageHelper {
    private static volatile boolean FLUX_INITIALIZED = false;
    private static Object FLUX_CAPABILITY = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFluxReflection() {
        if (FLUX_INITIALIZED) {
            return;
        }
        Class<EnergyStorageHelper> clazz = EnergyStorageHelper.class;
        synchronized (EnergyStorageHelper.class) {
            if (FLUX_INITIALIZED) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                Class<?> fluxCapClass = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
                Field blockCapField = fluxCapClass.getField("BLOCK");
                FLUX_CAPABILITY = blockCapField.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            FLUX_INITIALIZED = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static long extractEnergy(BlockEntity be, @Nullable Direction side, long maxExtract, boolean simulate) {
        if (be == null || be.isRemoved()) {
            return -1L;
        }
        Level level = be.getLevel();
        if (level == null) {
            return -1L;
        }
        long fluxExtracted = EnergyStorageHelper.tryExtractFluxEnergy(be, level, side, maxExtract, simulate);
        if (fluxExtracted >= 0L) {
            return fluxExtracted;
        }
        long gtExtracted = EnergyStorageHelper.tryExtractGTEnergy(be, level, side, maxExtract, simulate);
        if (gtExtracted >= 0L) {
            return gtExtracted;
        }
        IEnergyStorage normalCap = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, be.getBlockPos(), be.getBlockState(), be, (Object)side);
        if (normalCap != null && normalCap.canExtract()) {
            int maxInt = (int)Math.min(maxExtract, Integer.MAX_VALUE);
            return normalCap.extractEnergy(maxInt, simulate);
        }
        return -1L;
    }

    public static long insertEnergy(BlockEntity be, @Nullable Direction side, long maxInsert, boolean simulate) {
        if (be == null || be.isRemoved()) {
            return -1L;
        }
        Level level = be.getLevel();
        if (level == null) {
            return -1L;
        }
        long fluxInserted = EnergyStorageHelper.tryInsertFluxEnergy(be, level, side, maxInsert, simulate);
        if (fluxInserted >= 0L) {
            return fluxInserted;
        }
        long gtInserted = EnergyStorageHelper.tryInsertGTEnergy(be, level, side, maxInsert, simulate);
        if (gtInserted >= 0L) {
            return gtInserted;
        }
        IEnergyStorage normalCap = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, be.getBlockPos(), be.getBlockState(), be, (Object)side);
        if (normalCap != null && normalCap.canReceive()) {
            int maxInt = (int)Math.min(maxInsert, Integer.MAX_VALUE);
            return normalCap.receiveEnergy(maxInt, simulate);
        }
        return -1L;
    }

    public static boolean canExtract(BlockEntity be, @Nullable Direction side) {
        IEnergyStorage normalCap;
        if (be == null || be.isRemoved()) {
            return false;
        }
        Level level = be.getLevel();
        if (level == null) {
            return false;
        }
        EnergyStorageHelper.initFluxReflection();
        if (FLUX_CAPABILITY != null) {
            try {
                Method canExtractMethod;
                Method getCapMethod = level.getClass().getMethod("getCapability", BlockCapability.class, BlockPos.class, BlockState.class, BlockEntity.class, Object.class);
                Object fluxCap = getCapMethod.invoke((Object)level, FLUX_CAPABILITY, be.getBlockPos(), be.getBlockState(), be, side);
                if (fluxCap != null && ((Boolean)(canExtractMethod = fluxCap.getClass().getMethod("canExtract", new Class[0])).invoke(fluxCap, new Object[0])).booleanValue()) {
                    return true;
                }
            }
            catch (Exception getCapMethod) {
                // empty catch block
            }
        }
        return (normalCap = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, be.getBlockPos(), be.getBlockState(), be, (Object)side)) != null && normalCap.canExtract();
    }

    public static boolean canReceive(BlockEntity be, @Nullable Direction side) {
        IEnergyStorage normalCap;
        if (be == null || be.isRemoved()) {
            return false;
        }
        Level level = be.getLevel();
        if (level == null) {
            return false;
        }
        EnergyStorageHelper.initFluxReflection();
        if (FLUX_CAPABILITY != null) {
            try {
                Method canReceiveMethod;
                Method getCapMethod = level.getClass().getMethod("getCapability", BlockCapability.class, BlockPos.class, BlockState.class, BlockEntity.class, Object.class);
                Object fluxCap = getCapMethod.invoke((Object)level, FLUX_CAPABILITY, be.getBlockPos(), be.getBlockState(), be, side);
                if (fluxCap != null && ((Boolean)(canReceiveMethod = fluxCap.getClass().getMethod("canReceive", new Class[0])).invoke(fluxCap, new Object[0])).booleanValue()) {
                    return true;
                }
            }
            catch (Exception getCapMethod) {
                // empty catch block
            }
        }
        return (normalCap = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, be.getBlockPos(), be.getBlockState(), be, (Object)side)) != null && normalCap.canReceive();
    }

    public static long getEnergyStored(BlockEntity be, @Nullable Direction side) {
        IEnergyStorage normalCap;
        if (be == null || be.isRemoved()) {
            return 0L;
        }
        Level level = be.getLevel();
        if (level == null) {
            return 0L;
        }
        EnergyStorageHelper.initFluxReflection();
        if (FLUX_CAPABILITY != null) {
            try {
                Method getCapMethod = level.getClass().getMethod("getCapability", BlockCapability.class, BlockPos.class, BlockState.class, BlockEntity.class, Object.class);
                Object fluxCap = getCapMethod.invoke((Object)level, FLUX_CAPABILITY, be.getBlockPos(), be.getBlockState(), be, side);
                if (fluxCap != null) {
                    Method getEnergyStoredMethod = fluxCap.getClass().getMethod("getEnergyStoredL", new Class[0]);
                    return (Long)getEnergyStoredMethod.invoke(fluxCap, new Object[0]);
                }
            }
            catch (Exception getCapMethod) {
                // empty catch block
            }
        }
        return (normalCap = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, be.getBlockPos(), be.getBlockState(), be, (Object)side)) != null ? (long)normalCap.getEnergyStored() : 0L;
    }

    private static long tryExtractFluxEnergy(BlockEntity be, Level level, @Nullable Direction side, long maxExtract, boolean simulate) {
        EnergyStorageHelper.initFluxReflection();
        if (FLUX_CAPABILITY == null) {
            return -1L;
        }
        try {
            Method canExtractMethod;
            Method getCapMethod = level.getClass().getMethod("getCapability", BlockCapability.class, BlockPos.class, BlockState.class, BlockEntity.class, Object.class);
            Object fluxCap = getCapMethod.invoke((Object)level, FLUX_CAPABILITY, be.getBlockPos(), be.getBlockState(), be, side);
            if (fluxCap != null && ((Boolean)(canExtractMethod = fluxCap.getClass().getMethod("canExtract", new Class[0])).invoke(fluxCap, new Object[0])).booleanValue()) {
                Method extractMethod = fluxCap.getClass().getMethod("extractEnergyL", Long.TYPE, Boolean.TYPE);
                return (Long)extractMethod.invoke(fluxCap, maxExtract, simulate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    private static long tryInsertFluxEnergy(BlockEntity be, Level level, @Nullable Direction side, long maxInsert, boolean simulate) {
        EnergyStorageHelper.initFluxReflection();
        if (FLUX_CAPABILITY == null) {
            return -1L;
        }
        try {
            Method canReceiveMethod;
            Method getCapMethod = level.getClass().getMethod("getCapability", BlockCapability.class, BlockPos.class, BlockState.class, BlockEntity.class, Object.class);
            Object fluxCap = getCapMethod.invoke((Object)level, FLUX_CAPABILITY, be.getBlockPos(), be.getBlockState(), be, side);
            if (fluxCap != null && ((Boolean)(canReceiveMethod = fluxCap.getClass().getMethod("canReceive", new Class[0])).invoke(fluxCap, new Object[0])).booleanValue()) {
                Method receiveMethod = fluxCap.getClass().getMethod("receiveEnergyL", Long.TYPE, Boolean.TYPE);
                return (Long)receiveMethod.invoke(fluxCap, maxInsert, simulate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    private static long tryExtractGTEnergy(BlockEntity be, Level level, @Nullable Direction side, long maxExtractFE, boolean simulate) {
        if (!GTEnergyAdapter.isGTAvailable()) {
            return -1L;
        }
        try {
            Method getEnergyStoredMethod;
            long storedEU;
            Method outputsEnergyMethod;
            boolean canOutput;
            Object gtCap = GTEnergyAdapter.getGTCapability();
            if (gtCap == null) {
                return -1L;
            }
            Method getCapMethod = level.getClass().getMethod("getCapability", BlockCapability.class, BlockPos.class, BlockState.class, BlockEntity.class, Object.class);
            Object gtContainer = getCapMethod.invoke((Object)level, gtCap, be.getBlockPos(), be.getBlockState(), be, side);
            if (gtContainer != null && (canOutput = ((Boolean)(outputsEnergyMethod = gtContainer.getClass().getMethod("outputsEnergy", Direction.class)).invoke(gtContainer, side)).booleanValue()) && (storedEU = ((Long)(getEnergyStoredMethod = gtContainer.getClass().getMethod("getEnergyStored", new Class[0])).invoke(gtContainer, new Object[0])).longValue()) > 0L) {
                long maxExtractEU = GTEnergyAdapter.feToEU(maxExtractFE);
                long toExtractEU = Math.min(storedEU, maxExtractEU);
                if (!simulate) {
                    Method changeEnergyMethod = gtContainer.getClass().getMethod("changeEnergy", Long.TYPE);
                    long extractedEU = -((Long)changeEnergyMethod.invoke(gtContainer, -toExtractEU)).longValue();
                    return GTEnergyAdapter.euToFE(extractedEU);
                }
                return GTEnergyAdapter.euToFE(toExtractEU);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    private static long tryInsertGTEnergy(BlockEntity be, Level level, @Nullable Direction side, long maxInsertFE, boolean simulate) {
        if (!GTEnergyAdapter.isGTAvailable()) {
            return -1L;
        }
        try {
            Object gtCap = GTEnergyAdapter.getGTCapability();
            if (gtCap == null) {
                return -1L;
            }
            Method getCapMethod = level.getClass().getMethod("getCapability", BlockCapability.class, BlockPos.class, BlockState.class, BlockEntity.class, Object.class);
            Object gtContainer = getCapMethod.invoke((Object)level, gtCap, be.getBlockPos(), be.getBlockState(), be, side);
            if (gtContainer != null) {
                Method inputsEnergyMethod = gtContainer.getClass().getMethod("inputsEnergy", Direction.class);
                boolean canInput = (Boolean)inputsEnergyMethod.invoke(gtContainer, side);
                if (canInput) {
                    Method getInputVoltageMethod = gtContainer.getClass().getMethod("getInputVoltage", new Class[0]);
                    Method getInputAmperageMethod = gtContainer.getClass().getMethod("getInputAmperage", new Class[0]);
                    Method getEnergyCanBeInsertedMethod = gtContainer.getClass().getMethod("getEnergyCanBeInserted", new Class[0]);
                    long voltage = (Long)getInputVoltageMethod.invoke(gtContainer, new Object[0]);
                    long amperage = (Long)getInputAmperageMethod.invoke(gtContainer, new Object[0]);
                    long canInsertEU = (Long)getEnergyCanBeInsertedMethod.invoke(gtContainer, new Object[0]);
                    if (canInsertEU > 0L) {
                        long maxInsertEU = GTEnergyAdapter.feToEU(maxInsertFE);
                        long toInsertEU = Math.min(canInsertEU, maxInsertEU);
                        long maxByVoltageAmperage = voltage * amperage;
                        if ((toInsertEU = Math.min(toInsertEU, maxByVoltageAmperage)) > 0L) {
                            if (!simulate) {
                                long actualVoltage = Math.min(voltage, toInsertEU);
                                long actualAmperage = Math.min(amperage, toInsertEU / Math.max(actualVoltage, 1L));
                                Method acceptEnergyMethod = gtContainer.getClass().getMethod("acceptEnergyFromNetwork", Direction.class, Long.TYPE, Long.TYPE);
                                long acceptedAmperage = (Long)acceptEnergyMethod.invoke(gtContainer, side, actualVoltage, actualAmperage);
                                long insertedEU = actualVoltage * acceptedAmperage;
                                return GTEnergyAdapter.euToFE(insertedEU);
                            }
                            return GTEnergyAdapter.euToFE(toInsertEU);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }
}

