/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.part;

import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.orientation.BlockOrientation;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import appeng.block.orientation.SpinMapping;
import appeng.block.storage.DriveBlock;
import appeng.blockentity.inventory.AppEngCellInventory;
import appeng.client.render.BakedModelUnwrapper;
import appeng.client.render.model.AEModelData;
import appeng.client.render.model.DriveBakedModel;
import appeng.client.render.tesr.CellLedRenderer;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.me.storage.DriveWatcher;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.util.InteractionUtil;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.client.render.FaceRotatingModel;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGAMenus;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellDockPart
extends AEBasePart
implements InternalInventoryHost,
IChestOrDrive,
IStorageProvider,
IPriorityHost {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellDockPart.class);
    @PartModels
    private static final IPartModel MODEL = new PartModel(MEGACells.makeId("part/cell_dock"));
    private final AppEngCellInventory cellInventory = new AppEngCellInventory((InternalInventoryHost)this, 1);
    private DriveWatcher cellWatcher;
    private boolean isCached = false;
    private boolean wasOnline = false;
    private int priority = 0;
    private Item clientCell = Items.AIR;
    private CellState clientCellState = CellState.ABSENT;
    private byte spin;

    public CellDockPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setIdlePowerUsage(0.5).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).addService(IStorageProvider.class, (IGridNodeService)this);
        this.cellInventory.setFilter((IAEItemFilter)new Filter());
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.cellInventory.setItemDirect(0, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)data.getCompound("cell")));
        this.priority = data.getInt("priority");
        this.spin = data.getByte("spin");
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        data.put("cell", this.getCell().saveOptional(registries));
        data.putInt("priority", this.priority);
        data.putByte("spin", this.spin);
    }

    public boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        Item oldCell = this.clientCell;
        CellState oldCellState = this.clientCellState;
        byte oldSpin = this.spin;
        this.clientCell = (Item)BuiltInRegistries.ITEM.get(data.readResourceLocation());
        this.clientCellState = (CellState)data.readEnum(CellState.class);
        this.spin = data.readByte();
        return changed || oldCell != this.clientCell || oldCellState != this.clientCellState || oldSpin != this.spin;
    }

    public void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)this.getCell().getItem()));
        this.clientCellState = this.getCellStatus(0);
        data.writeEnum((Enum)this.clientCellState);
        data.writeByte(this.spin);
    }

    public void readVisualStateFromNBT(CompoundTag data) {
        super.readVisualStateFromNBT(data);
        try {
            this.clientCell = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)data.getString("cellId")));
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't read cell item for {} from {}", (Object)this, (Object)data);
            this.clientCell = Items.AIR;
        }
        try {
            this.clientCellState = CellState.valueOf((String)data.getString("cellStatus"));
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't read cell status for {} from {}", (Object)this, (Object)data);
            this.clientCellState = CellState.ABSENT;
        }
        this.spin = data.getByte("spin");
    }

    public void writeVisualStateToNBT(CompoundTag data) {
        super.writeVisualStateToNBT(data);
        data.putString("cellId", BuiltInRegistries.ITEM.getKey((Object)this.getCell().getItem()).toString());
        data.putString("cellStatus", this.getCellStatus(0).name());
        data.putByte("spin", this.spin);
    }

    private void recalculateDisplay() {
        CellState cellState = this.getCellStatus(0);
        if (this.clientCellState != cellState) {
            this.getHost().markForUpdate();
            this.clientCellState = cellState;
        }
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        boolean online = this.getMainNode().isOnline();
        if (online != this.wasOnline) {
            this.wasOnline = online;
            IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
            this.recalculateDisplay();
        }
    }

    public boolean onUseWithoutItem(Player player, Vec3 pos) {
        if (!this.isClientSide()) {
            MenuOpener.open(MEGAMenus.CELL_DOCK.get(), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public boolean onUseItemOn(ItemStack heldItem, Player player, InteractionHand hand, Vec3 pos) {
        if (InteractionUtil.canWrenchRotate((ItemStack)heldItem)) {
            if (!this.isClientSide()) {
                this.spin = (byte)((this.spin + 1) % 4);
                this.getHost().markForSave();
                this.getHost().markForUpdate();
            }
            return true;
        }
        return super.onUseItemOn(heldItem, player, hand, pos);
    }

    public void onPlacement(Player player) {
        super.onPlacement(player);
        byte rotation = (byte)(Mth.floor((double)((double)(player.getYRot() * 4.0f / 360.0f) + 2.5)) & 3);
        if (this.getSide() == Direction.UP || this.getSide() == Direction.DOWN) {
            this.spin = rotation;
        }
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(MEGAMenus.CELL_DOCK.get(), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public ItemStack getMainMenuIcon() {
        return MEGAItems.CELL_DOCK.stack();
    }

    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        drops.add(this.getCell());
    }

    public AppEngCellInventory getCellInventory() {
        return this.cellInventory;
    }

    private ItemStack getCell() {
        return this.cellInventory.getStackInSlot(0);
    }

    public int getCellCount() {
        return 1;
    }

    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Nullable
    public Item getCellItem(int slot) {
        return slot == 0 ? this.cellInventory.getStackInSlot(slot).getItem() : null;
    }

    @Nullable
    public MEStorage getCellInventory(int slot) {
        return slot == 0 && this.cellWatcher != null ? this.cellWatcher : null;
    }

    @Nullable
    public StorageCell getOriginalCellInventory(int slot) {
        return slot == 0 && this.cellWatcher != null ? this.cellWatcher.getCell() : null;
    }

    public CellState getCellStatus(int slot) {
        return this.isClientSide() ? this.clientCellState : (slot == 0 && this.cellWatcher != null ? this.cellWatcher.getStatus() : CellState.ABSENT);
    }

    public void mountInventories(IStorageMounts storageMounts) {
        if (this.getMainNode().isOnline()) {
            this.updateState();
            if (this.cellWatcher != null) {
                storageMounts.mount((MEStorage)this.cellWatcher, this.priority);
            }
        }
    }

    public void saveChangedInventory(AppEngInternalInventory inv) {
        this.getHost().markForSave();
        this.getHost().markForUpdate();
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    private void updateState() {
        if (!this.isCached) {
            StorageCell cell;
            this.cellWatcher = null;
            this.cellInventory.setHandler(0, null);
            double power = 0.5;
            if (!this.getCell().isEmpty() && (cell = StorageCells.getCellInventory((ItemStack)this.getCell(), this::onCellContentChanged)) != null) {
                this.cellWatcher = new DriveWatcher(cell, this::recalculateDisplay);
                this.cellInventory.setHandler(0, cell);
                power += cell.getIdleDrain();
            }
            this.getMainNode().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    private void onCellContentChanged() {
        this.getLevel().blockEntityChanged(this.getBlockEntity().getBlockPos());
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.isCached = false;
        this.updateState();
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 12.0, 13.0, 13.0, 16.0);
        bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 12.0);
    }

    public boolean requireDynamicRender() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDynamic(float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        if (this.getLevel() == null || this.clientCell == Items.AIR) {
            return;
        }
        DriveBakedModel driveModel = (DriveBakedModel)BakedModelUnwrapper.unwrap((BakedModel)Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(((DriveBlock)AEBlocks.DRIVE.block()).defaultBlockState()), DriveBakedModel.class);
        if (driveModel == null) {
            LOGGER.error("Could not retrieve ME Drive model for associated cell chassis models.");
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        Direction front = SpinMapping.getUpFromSpin((Direction)this.getSide(), (int)this.spin);
        BlockOrientation orientation = BlockOrientation.get((Direction)front, (Direction)this.getSide());
        poseStack.mulPose(orientation.getQuaternion());
        poseStack.translate(-0.1875f, 0.3125f, -0.25f);
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().tesselateBlock((BlockAndTintGetter)this.getLevel(), (BakedModel)new FaceRotatingModel(driveModel.getCellChassisModel(this.clientCell), orientation), this.getBlockEntity().getBlockState(), this.getBlockEntity().getBlockPos(), poseStack, buffers.getBuffer(RenderType.cutout()), false, RandomSource.create(), 0L, combinedOverlayIn, ModelData.EMPTY, null);
        CellLedRenderer.renderLed((IChestOrDrive)this, (int)0, (VertexConsumer)buffers.getBuffer(CellLedRenderer.RENDER_LAYER), (PoseStack)poseStack, (float)partialTicks);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(BlockOrientation.get((Direction)this.getSide(), (int)this.spin).getQuaternion());
        poseStack.translate(-0.5f, -0.1875f, -0.5f);
        CellLedRenderer.renderLed((IChestOrDrive)this, (int)0, (VertexConsumer)buffers.getBuffer(CellLedRenderer.RENDER_LAYER), (PoseStack)poseStack, (float)partialTicks);
        poseStack.popPose();
    }

    public ModelData getModelData() {
        return ModelData.builder().with(AEModelData.SPIN, (Object)this.spin).build();
    }

    private static class Filter
    implements IAEItemFilter {
        private Filter() {
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return StorageCells.isCellHandled((ItemStack)stack);
        }
    }
}

