/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.mekagenjei.client.jei.api;

import com.devdyna.mekagenjei.client.jei.api.BaseRecipeCategory;
import com.devdyna.mekagenjei.utils.Numbers;
import com.devdyna.mekagenjei.utils.Pos;
import com.devdyna.mekagenjei.utils.Size;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public abstract class FuelCategory<T>
extends BaseRecipeCategory<T> {
    public FuelCategory(IGuiHelper h) {
        super(h);
    }

    public abstract void setSlotType(T var1, IRecipeSlotBuilder var2);

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup group) {
        this.setSlotType(recipe, builder.addInputSlot(1, 8));
    }

    public abstract double rate(T var1);

    public abstract double duration(T var1);

    @Override
    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        double time = this.duration(recipe);
        double rate = this.rate(recipe);
        double total = time * rate;
        PoseStack stack = guiGraphics.pose();
        stack.pushPose();
        stack.scale(0.75f, 0.75f, 8000.0f);
        guiGraphics.drawString(this.font, Screen.hasShiftDown() ? ("" + time / 20.0).replaceAll("\\.0$", "") + " sec" : time + " ticks", 46, 4, 0xFFFFFF);
        guiGraphics.drawString(this.font, String.valueOf(Screen.hasShiftDown() ? Numbers.toCompact(rate) : Double.valueOf(rate)) + " FE/tick", 46, 18, 0xFFFFFF);
        guiGraphics.drawString(this.font, String.valueOf(Screen.hasShiftDown() ? Numbers.toCompact(total) : Double.valueOf(total)) + " FE", 46, 32, 0xFFFFFF);
        stack.popPose();
    }

    public void getTooltip(ITooltipBuilder tooltip, T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (Pos.of(21, 0).setSize(10, 10).test(mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.translatable((String)"mekagenjei.jei.time"));
        }
        if (Pos.of(21, 11).setSize(10, 10).test(mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.translatable((String)"mekagenjei.jei.rate"));
        }
        if (Pos.of(21, 22).setSize(10, 10).test(mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.translatable((String)"mekagenjei.jei.total"));
        }
    }

    @Override
    public Size setXY() {
        return Size.of(96, 32);
    }

    @Override
    @Nullable
    public String setBackGround() {
        return "textures/gui/fuel_icons.png";
    }
}

