/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.mekanism_unleashed.mixin;

import dev.wp.mekanism_unleashed.Utils;
import mekanism.api.math.MathUtils;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.MekanismUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={MekanismUtils.class}, remap=false)
public class MixinMekanismUtils {
    @Overwrite
    public static int getTicks(IUpgradeTile tile, int def) {
        if (tile.supportsUpgrades()) {
            int ticks = MathUtils.clampToInt((double)MixinMekanismUtils.getTicksD(tile, def));
            if (Utils.isCrafter(tile)) {
                return Math.max(1, ticks);
            }
            return ticks;
        }
        return def;
    }

    @Overwrite
    public static double getTicksD(IUpgradeTile tile, int def) {
        double d = (double)def * Utils.time(tile);
        return d >= 1.0 ? (double)MathUtils.clampToInt((double)d) : (double)(MathUtils.clampToInt((double)(1.0 / d)) * -1);
    }

    @Overwrite
    public static int getOperationsPerTick(IUpgradeTile tile, int defTicks, int defaultOperations) {
        double ticksD = MixinMekanismUtils.getTicksD(tile, defTicks);
        if (ticksD >= 1.0) {
            return defaultOperations;
        }
        return MathUtils.clampToInt((double)(Math.max(1.0, -ticksD) * (double)defaultOperations));
    }

    @Overwrite
    public static long getEnergyPerTick(IUpgradeTile tile, long def) {
        if (tile.supportsUpgrades()) {
            return MathUtils.clampToLong((double)((double)def * Utils.electricity(tile)));
        }
        return def;
    }

    @Overwrite
    public static long getMaxEnergy(IUpgradeTile tile, long def) {
        if (tile.supportsUpgrades()) {
            return MathUtils.clampToLong((double)((double)def * Utils.capacity(tile)));
        }
        return def;
    }

    @Overwrite
    public static long getMaxEnergy(int energyUpgrades, long def) {
        return MathUtils.clampToLong((double)((double)def * Utils.capacity(energyUpgrades)));
    }
}

