/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.su5ed.mffs.render.LazyRenderer;
import dev.su5ed.mffs.render.RenderPostProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

@EventBusSubscriber(modid="mffs", value={Dist.CLIENT})
public final class RenderTickHandler {
    private static final Map<RenderType, List<LazyRenderer>> transparentRenderers = new HashMap<RenderType, List<LazyRenderer>>();

    public static void addTransparentRenderer(RenderType renderType, LazyRenderer render) {
        transparentRenderers.computeIfAbsent(renderType, r -> new ArrayList()).add(render);
    }

    @SubscribeEvent
    public static void onTick(ClientTickEvent.Pre event) {
        transparentRenderers.clear();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            Minecraft minecraft = Minecraft.getInstance();
            Camera camera = event.getCamera();
            PoseStack poseStack = event.getPoseStack();
            int ticks = event.getRenderTick();
            DeltaTracker partialTicks = event.getPartialTick();
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            RenderPostProcessor.prepareRender();
            poseStack.pushPose();
            Vec3 camPos = camera.getPosition();
            poseStack.translate(-camPos.x, -camPos.y, -camPos.z);
            Consumer<TransparentRenderInfo> consumer = info -> info.render(poseStack, bufferSource, ticks, partialTicks.getGameTimeDeltaPartialTick(false));
            if (transparentRenderers.size() == 1) {
                EntryStream.of(transparentRenderers).mapKeyValue(TransparentRenderInfo::new).forEach(consumer);
            } else {
                ((StreamEx)EntryStream.of(transparentRenderers).mapKeyValue((renderType, renderers) -> {
                    double closest = StreamEx.of((Collection)renderers).mapPartial(renderer -> Optional.ofNullable(renderer.centerPos())).mapToDouble(arg_0 -> ((Vec3)camPos).distanceToSqr(arg_0)).min().orElse(Double.MAX_VALUE);
                    return new TransparentRenderInfo((RenderType)renderType, (List<LazyRenderer>)renderers, closest);
                }).reverseSorted(Comparator.comparingDouble(TransparentRenderInfo::closest))).forEachOrdered(consumer);
            }
            transparentRenderers.clear();
            poseStack.popPose();
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            RenderPostProcessor.process(event.getRenderTick());
        }
    }

    private RenderTickHandler() {
    }

    public record TransparentRenderInfo(RenderType renderType, List<LazyRenderer> renders, double closest) {
        public TransparentRenderInfo(RenderType renderType, List<LazyRenderer> renders) {
            this(renderType, renders, 0.0);
        }

        private void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, int ticks, float partialTicks) {
            VertexConsumer buffer = bufferSource.getBuffer(this.renderType);
            for (LazyRenderer renderer : this.renders) {
                renderer.render(poseStack, buffer, ticks, partialTicks);
            }
            bufferSource.endBatch(this.renderType);
        }
    }
}

