/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util;

import dev.su5ed.mffs.api.fortron.FortronStorage;
import dev.su5ed.mffs.api.module.ModuleAcceptor;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.api.security.InterdictionMatrix;
import dev.su5ed.mffs.network.DrawBeamPacket;
import dev.su5ed.mffs.render.particle.BeamParticleOptions;
import dev.su5ed.mffs.render.particle.ParticleColor;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.setup.ModFluids;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.util.FrequencyGrid;
import dev.su5ed.mffs.util.TransferMode;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;
import one.util.streamex.StreamEx;

public final class Fortron {
    public static FluidStack getFortron(int amount) {
        return new FluidStack((Fluid)ModFluids.FORTRON_FLUID.get(), amount);
    }

    public static void transferFortron(FortronStorage transmitter, Collection<? extends FortronStorage> receivers, TransferMode transferMode, int limit) {
        if (transmitter != null && receivers.size() > 1) {
            int totalFortron = 0;
            int totalCapacity = 0;
            for (FortronStorage fortronStorage : receivers) {
                totalFortron += fortronStorage.getStoredFortron();
                totalCapacity += fortronStorage.getFortronCapacity();
            }
            receivers.remove(transmitter);
            if (totalFortron > 0 && totalCapacity > 0) {
                switch (transferMode) {
                    case EQUALIZE: {
                        for (FortronStorage fortronStorage : receivers) {
                            double d = (double)fortronStorage.getFortronCapacity() / (double)totalCapacity;
                            int amountToSet = (int)((double)totalFortron * d);
                            Fortron.doTransferFortron(transmitter, fortronStorage, amountToSet - fortronStorage.getStoredFortron(), limit);
                        }
                        break;
                    }
                    case DISTRIBUTE: {
                        int amountToSet = totalFortron / receivers.size();
                        for (FortronStorage fortronStorage : receivers) {
                            Fortron.doTransferFortron(transmitter, fortronStorage, amountToSet - fortronStorage.getStoredFortron(), limit);
                        }
                        break;
                    }
                    case DRAIN: {
                        for (FortronStorage fortronStorage : receivers) {
                            double d = (double)fortronStorage.getFortronCapacity() / (double)totalCapacity;
                            int amountToSet = (int)((double)totalFortron * d);
                            if (amountToSet - fortronStorage.getStoredFortron() <= 0) continue;
                            Fortron.doTransferFortron(transmitter, fortronStorage, amountToSet - fortronStorage.getStoredFortron(), limit);
                        }
                        break;
                    }
                    case FILL: {
                        if (transmitter.getStoredFortron() >= transmitter.getFortronCapacity()) break;
                        int requiredFortron = transmitter.getFortronCapacity() - transmitter.getStoredFortron();
                        for (FortronStorage fortronStorage : receivers) {
                            int amountToConsume = Math.min(requiredFortron, fortronStorage.getStoredFortron());
                            int amountToSet = -fortronStorage.getStoredFortron() - amountToConsume;
                            if (amountToConsume <= 0) continue;
                            Fortron.doTransferFortron(transmitter, fortronStorage, amountToSet - fortronStorage.getStoredFortron(), limit);
                        }
                        break;
                    }
                }
            }
        }
    }

    public static void doTransferFortron(FortronStorage transmitter, FortronStorage receiver, int joules, int limit) {
        ModuleAcceptor acceptor;
        boolean isCamo;
        boolean bl = isCamo = transmitter instanceof ModuleAcceptor && (acceptor = (ModuleAcceptor)((Object)transmitter)).hasModule(ModModules.CAMOUFLAGE);
        if (joules > 0) {
            Fortron.doTransferFortron(transmitter, receiver, joules, limit, isCamo);
        } else {
            Fortron.doTransferFortron(receiver, transmitter, joules, limit, isCamo);
        }
    }

    public static void renderBeam(ClientLevel level, Vec3 target, Vec3 position, ParticleColor color, int lifetime) {
        level.addParticle((ParticleOptions)new BeamParticleOptions(target, color, lifetime), position.x(), position.y(), position.z(), 0.0, 0.0, 0.0);
    }

    public static void renderClientBeam(Level level, Vec3 target, Vec3 position, BlockPos chunkPos, ParticleColor color, int lifetime) {
        DrawBeamPacket packet = new DrawBeamPacket(target, position, color, lifetime);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)level.getChunkAt(chunkPos).getPos(), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static boolean hasPermission(Level level, BlockPos pos, FieldPermission permission, Player player) {
        InterdictionMatrix interdictionMatrix = Fortron.getNearestInterdictionMatrix(level, pos);
        return interdictionMatrix == null || Fortron.isPermittedByInterdictionMatrix(interdictionMatrix, player, permission);
    }

    public static boolean hasPermission(Level level, BlockPos pos, InterdictionMatrix interdictionMatrix, Action action, Player player) {
        boolean hasPermission = true;
        if (action == Action.RIGHT_CLICK_BLOCK && level.getBlockEntity(pos) != null && interdictionMatrix.hasModule(ModModules.BLOCK_ACCESS)) {
            hasPermission = Fortron.isPermittedByInterdictionMatrix(interdictionMatrix, player, FieldPermission.USE_BLOCKS);
        }
        if (hasPermission && interdictionMatrix.hasModule(ModModules.BLOCK_ALTER) && (player.getItemInHand(InteractionHand.MAIN_HAND) != null || action == Action.LEFT_CLICK_BLOCK)) {
            hasPermission = Fortron.isPermittedByInterdictionMatrix(interdictionMatrix, player, FieldPermission.PLACE_BLOCKS);
        }
        return hasPermission;
    }

    public static InterdictionMatrix getNearestInterdictionMatrix(Level level, BlockPos pos) {
        return StreamEx.of(FrequencyGrid.instance(level.isClientSide).get()).mapPartial(storage -> {
            BlockEntity be = storage.getOwner();
            return be.getLevel() == level ? Optional.ofNullable((InterdictionMatrix)level.getCapability(ModCapabilities.INTERDICTION_MATRIX, be.getBlockPos(), be.getBlockState(), be, null)).filter(interdictionMatrix -> interdictionMatrix.isActive() && pos.closerThan((Vec3i)be.getBlockPos(), (double)interdictionMatrix.getActionRange())) : Optional.empty();
        }).findFirst().orElse(null);
    }

    public static boolean isPermittedByInterdictionMatrix(InterdictionMatrix interdictionMatrix, Player player, FieldPermission ... permissions) {
        if (interdictionMatrix != null && interdictionMatrix.isActive() && interdictionMatrix.getBiometricIdentifier() != null) {
            for (FieldPermission permission : permissions) {
                if (interdictionMatrix.getBiometricIdentifier().isAccessGranted(player, permission)) continue;
                return interdictionMatrix.hasModule(ModModules.INVERTER);
            }
        }
        return !interdictionMatrix.hasModule(ModModules.INVERTER);
    }

    private static void doTransferFortron(FortronStorage source, FortronStorage destination, int joules, int limit, boolean isCamo) {
        int transfer = Math.min(Math.abs(joules), limit);
        int available = destination.insertFortron(source.extractFortron(transfer, true), true);
        int transferred = source.extractFortron(destination.insertFortron(available, false), false);
        if (transferred > 0 && !isCamo) {
            BlockEntity sourceBe = source.getOwner();
            BlockPos sourcePos = sourceBe.getBlockPos();
            Level level = sourceBe.getLevel();
            Vec3 target = Vec3.atCenterOf((Vec3i)destination.getOwner().getBlockPos());
            Vec3 position = Vec3.atCenterOf((Vec3i)sourcePos);
            ParticleColor color = ParticleColor.BLUE_BEAM;
            int lifetime = 20;
            if (level.isClientSide()) {
                ClientLevel clientLevel = (ClientLevel)level;
                Fortron.renderBeam(clientLevel, target, position, color, lifetime);
            } else {
                Fortron.renderClientBeam(level, target, position, sourcePos, color, lifetime);
            }
        }
    }

    private Fortron() {
    }

    public static enum Action {
        RIGHT_CLICK_BLOCK,
        LEFT_CLICK_BLOCK;

    }
}

