/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.projector;

import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.ProjectorMode;
import dev.su5ed.mffs.setup.ModModules;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class SphereProjectorMode
implements ProjectorMode {
    @Override
    public Set<Vec3> getExteriorPoints(Projector projector) {
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        int radius = projector.getModuleCount(ModModules.SCALE);
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / (double)radius / 2.0));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int theta_n = 0; theta_n < steps; ++theta_n) {
                double phi = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)theta_n;
                double x = Math.sin(theta) * Math.cos(phi) * (double)radius;
                double y = Math.cos(theta) * (double)radius;
                double z = Math.sin(theta) * Math.sin(phi) * (double)radius;
                fieldBlocks.add(new Vec3(x, y, z));
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vec3> getInteriorPoints(Projector projector) {
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos projectorPos = projector.be().getBlockPos().offset((Vec3i)projector.getTranslation());
        int radius = projector.getModuleCount(ModModules.SCALE);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    Vec3 position = new Vec3((double)x, (double)y, (double)z);
                    if (!this.isInField(projector, position.add((double)projectorPos.getX(), (double)projectorPos.getY(), (double)projectorPos.getZ()), 0.1)) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(Projector projector, Vec3 position) {
        return this.isInField(projector, position, -0.5);
    }

    private boolean isInField(Projector projector, Vec3 position, double tolerance) {
        BlockPos projectorPos = projector.be().getBlockPos();
        int radius = projector.getModuleCount(ModModules.SCALE);
        return projectorPos.offset((Vec3i)projector.getTranslation()).closerThan((Vec3i)BlockPos.containing((Position)position), (double)radius + tolerance);
    }
}

