/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.ftb.mods.mecrh.entity.EggBomb;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class EggBombRenderer
extends EntityRenderer<EggBomb> {
    public EggBombRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EggBomb entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Level world;
        BlockState state = Blocks.DRAGON_EGG.defaultBlockState();
        if (state.getRenderShape() == RenderShape.MODEL && state != (world = entity.getCommandSenderWorld()).getBlockState(entity.blockPosition()) && state.getRenderShape() != RenderShape.INVISIBLE) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.5, 0.0);
            float angle = ((float)entity.tickCount + partialTick) * 18.0f;
            poseStack.mulPose(Axis.YP.rotationDegrees(angle));
            poseStack.translate(-0.5, -0.5, -0.5);
            BlockPos blockpos = BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ());
            BlockRenderDispatcher renderer = Minecraft.getInstance().getBlockRenderer();
            BakedModel blockModel = renderer.getBlockModel(state);
            for (RenderType type : blockModel.getRenderTypes(state, world.getRandom(), ModelData.EMPTY)) {
                renderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)world, blockModel, state, blockpos, poseStack, bufferSource.getBuffer(type), false, world.getRandom(), 0L, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, type);
            }
            poseStack.popPose();
        }
    }

    public ResourceLocation getTextureLocation(EggBomb eggBomb) {
        return null;
    }
}

