/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.ftb.mods.mecrh.MECRHMod;
import dev.ftb.mods.mecrh.client.model.EnderChickenModel;
import dev.ftb.mods.mecrh.entity.EnderChicken;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.specialty.DynamicGeoEntityRenderer;

public class EnderChickenRenderer
extends DynamicGeoEntityRenderer<EnderChicken> {
    private static final ResourceLocation SHIELD_TEXTURE = MECRHMod.id("textures/entity/chicken_shield_layer.png");

    public EnderChickenRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new EnderChickenModel());
        this.addRenderLayer(new LaserLayer(this));
    }

    public static EnderChickenRenderer scaled(EntityRendererProvider.Context renderManager, float scale) {
        return (EnderChickenRenderer)new EnderChickenRenderer(renderManager).withScale(scale);
    }

    @Nullable
    protected ResourceLocation getTextureOverrideForBone(GeoBone bone, EnderChicken animatable, float partialTick) {
        return this.isShieldBone(bone) ? SHIELD_TEXTURE : null;
    }

    @Nullable
    protected RenderType getRenderTypeOverrideForBone(GeoBone bone, EnderChicken animatable, ResourceLocation texturePath, MultiBufferSource bufferSource, float partialTick) {
        if (this.isShieldBone(bone)) {
            float f = (float)animatable.tickCount + partialTick;
            return RenderType.energySwirl((ResourceLocation)SHIELD_TEXTURE, (float)(EnderChickenRenderer.xOffset(f) % 1.0f), (float)(f * 0.01f % 1.0f));
        }
        return null;
    }

    private static float xOffset(float tickCount) {
        return Mth.cos((float)(tickCount * 0.01f)) * 3.0f;
    }

    protected boolean boneRenderOverride(PoseStack poseStack, GeoBone bone, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int colour) {
        return this.isShieldBone(bone) && !((EnderChicken)this.animatable).isForceField();
    }

    private boolean isShieldBone(GeoBone bone) {
        return bone.getName().endsWith("_armour");
    }

    private class LaserLayer
    extends GeoRenderLayer<EnderChicken> {
        public LaserLayer(EnderChickenRenderer enderChickenRenderer) {
            super((GeoRenderer)enderChickenRenderer);
        }

        public void render(PoseStack poseStack, EnderChicken animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            int progress = animatable.getFiringProgress();
            if (animatable.isAlive() && animatable.isFiringLaser() && progress > 59 && progress < 160) {
                poseStack.pushPose();
                Vec3 origin = animatable.partBill.position().subtract(animatable.position()).scale(0.66667);
                poseStack.translate(origin.x, origin.y, origin.z);
                Vec3 target = origin.add(animatable.getViewVector(partialTick).normalize().scale(animatable.getLaserLength()));
                Vec3 laserVec = target.subtract(origin);
                float beamLength = (float)(laserVec.length() + 1.0);
                laserVec = laserVec.normalize();
                float pitch = (float)Math.acos(laserVec.y);
                float yaw = (float)Math.atan2(laserVec.z, laserVec.x);
                poseStack.mulPose(Axis.YP.rotation(1.5707964f - yaw));
                poseStack.mulPose(Axis.XP.rotation(pitch));
                float beamRadius = 0.2f;
                float glowRadius = 0.25f;
                int color = -2065926;
                float time = (float)Math.floorMod(animatable.level().getGameTime(), 40) + partialTick;
                float f1 = beamLength < 0.0f ? time : -time;
                float f2 = Mth.frac((float)(f1 * 0.2f - (float)Mth.floor((float)(f1 * 0.1f))));
                float maxV = f2 - 1.0f;
                float minV = beamLength * (0.5f / beamRadius) + maxV;
                poseStack.pushPose();
                poseStack.mulPose(Axis.YP.rotationDegrees(time * 2.25f - 45.0f));
                LaserLayer.renderLaser(poseStack, bufferSource.getBuffer(RenderType.beaconBeam((ResourceLocation)BeaconRenderer.BEAM_LOCATION, (boolean)false)), color, 0.0f, beamLength, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, 0.0f, 1.0f, minV, maxV);
                poseStack.popPose();
                LaserLayer.renderLaser(poseStack, bufferSource.getBuffer(RenderType.beaconBeam((ResourceLocation)BeaconRenderer.BEAM_LOCATION, (boolean)true)), FastColor.ARGB32.color((int)32, (int)color), 0.0f, beamLength, 0.0f, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, minV, maxV);
                poseStack.popPose();
            }
        }

        private static void renderLaser(PoseStack poseStack, VertexConsumer consumer, int color, float minY, float maxY, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float minU, float maxU, float minV, float maxV) {
            PoseStack.Pose pose = poseStack.last();
            LaserLayer.renderQuad(pose, consumer, color, minY, maxY, x1, z1, x2, z2, minU, maxU, minV, maxV);
            LaserLayer.renderQuad(pose, consumer, color, minY, maxY, x4, z4, x3, z3, minU, maxU, minV, maxV);
            LaserLayer.renderQuad(pose, consumer, color, minY, maxY, x2, z2, x4, z4, minU, maxU, minV, maxV);
            LaserLayer.renderQuad(pose, consumer, color, minY, maxY, x3, z3, x1, z1, minU, maxU, minV, maxV);
        }

        private static void renderQuad(PoseStack.Pose pose, VertexConsumer consumer, int color, float minY, float maxY, float minX, float minZ, float maxX, float maxZ, float minU, float maxU, float minV, float maxV) {
            LaserLayer.addVertex(pose, consumer, color, maxY, minX, minZ, maxU, minV);
            LaserLayer.addVertex(pose, consumer, color, minY, minX, minZ, maxU, maxV);
            LaserLayer.addVertex(pose, consumer, color, minY, maxX, maxZ, minU, maxV);
            LaserLayer.addVertex(pose, consumer, color, maxY, maxX, maxZ, minU, minV);
        }

        private static void addVertex(PoseStack.Pose pose, VertexConsumer consumer, int color, float y, float x, float z, float u, float v) {
            consumer.addVertex(pose, x, y, z).setColor(color).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        }
    }

    private class ChickenGlowLayer
    extends AutoGlowingGeoLayer<EnderChicken> {
        public ChickenGlowLayer(EnderChickenRenderer enderChickenRenderer) {
            super((GeoRenderer)enderChickenRenderer);
        }

        public void render(PoseStack poseStack, EnderChicken animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            if (animatable.isFiringLaser()) {
                super.render(poseStack, (GeoAnimatable)animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            }
        }
    }
}

