/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.entity.ai;

import com.google.common.base.Predicate;
import dev.ftb.mods.mecrh.entity.EggBomb;
import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.entity.ai.ChickenGoal;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.phys.AABB;

public class ClearSurroundingEntitiesGoal
extends ChickenGoal {
    public static final Predicate<Entity> SPECIAL = e -> !(e instanceof Player && e.isSpectator() || !(e instanceof LivingEntity) && (!(e instanceof Projectile) || e instanceof Arrow && ((Arrow)e).onGround()) || e instanceof EggBomb || e instanceof EnderChicken);
    private int flapTime;

    public ClearSurroundingEntitiesGoal(EnderChicken chicken) {
        super(chicken);
    }

    @Override
    public boolean canUse() {
        if (this.chicken.onGround() && this.chicken.canUseAbility()) {
            for (Player player : this.chicken.level().players()) {
                if (player.getAbilities().invulnerable || !player.isAlive() || player.isSpectator() || !(player.getMainHandItem().getItem() instanceof BowItem) || !player.isUsingItem()) continue;
                return true;
            }
            if (this.chicken.canUseAbility()) {
                AABB aabb = this.chicken.getBoundingBox().move(0.0, (double)(-this.chicken.getBbHeight() * 0.15f), 0.0).inflate((double)(this.chicken.getBbWidth() * 0.45f), 0.0, (double)(this.chicken.getBbWidth() * 0.45f));
                List entities = this.chicken.level().getEntities((Entity)this.chicken, aabb, SPECIAL);
                return entities.stream().anyMatch(e -> this.chicken.getSensing().hasLineOfSight(e));
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.flapTime > 0 && this.chicken.onGround() && this.chicken.isAlive();
    }

    public void start() {
        this.chicken.useAbility();
        this.chicken.setFlapping(true);
        this.flapTime = 60;
    }

    public void stop() {
        this.chicken.endAbility();
        this.chicken.setFlapping(false);
        this.flapTime = 0;
    }

    public void tick() {
        --this.flapTime;
    }
}

