/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.modernworldcreation;

import de.keksuccino.modernworldcreation.ModernWorldCreation;
import de.keksuccino.modernworldcreation.mixin.mixins.common.client.IMixinCreateWorldScreen;
import de.keksuccino.modernworldcreation.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.modernworldcreation.mixin.mixins.common.client.IMixinTabNavigationBar;
import de.keksuccino.modernworldcreation.util.fancymenu.FMAccess;
import de.keksuccino.modernworldcreation.util.fancymenu.FMUtils;
import de.keksuccino.modernworldcreation.util.rendering.gui.ExtendedTabManager;
import de.keksuccino.modernworldcreation.util.rendering.gui.widgets.ArrowButton;
import de.keksuccino.modernworldcreation.util.rendering.gui.widgets.ToggleModeButton;
import de.keksuccino.modernworldcreation.util.rendering.screens.ExtendedCreateWorldScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.CommonLayouts;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModernWorldCreationGameTab
extends GridLayoutTab {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation BUTTON_TEXTURE_SURVIVAL = ResourceLocation.fromNamespaceAndPath((String)"modernworldcreation", (String)"textures/gamemodes/background_survival.png");
    private static final ResourceLocation BUTTON_TEXTURE_CREATIVE = ResourceLocation.fromNamespaceAndPath((String)"modernworldcreation", (String)"textures/gamemodes/background_creative.png");
    private static final ResourceLocation BUTTON_TEXTURE_HARDCORE = ResourceLocation.fromNamespaceAndPath((String)"modernworldcreation", (String)"textures/gamemodes/background_hardcore.png");
    private static final Component SURVIVAL_LABEL = Component.translatable((String)"modernworldcreation.gamemodes.survival").setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final Component CREATIVE_LABEL = Component.translatable((String)"modernworldcreation.gamemodes.creative").setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final Component HARDCORE_LABEL = Component.translatable((String)"modernworldcreation.gamemodes.hardcore").setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    protected static final Component NAME_LABEL = Component.translatable((String)"selectWorld.enterName");
    protected static final Component EXPERIMENTS_LABEL = Component.translatable((String)"selectWorld.experiments");
    protected static final Component ALLOW_COMMANDS_INFO = Component.translatable((String)"selectWorld.allowCommands.info");
    protected static final Component TITLE = Component.translatable((String)"createWorld.tab.game.title");
    protected static final Component ALLOW_COMMANDS = Component.translatable((String)"selectWorld.allowCommands");
    protected final Font font;
    protected EditBox nameEdit;
    protected ArrowButton arrowLeftButton;
    protected ArrowButton arrowRightButton;
    protected ToggleModeButton gamemodeSurvivalButton;
    protected ToggleModeButton gamemodeCreativeButton;
    protected ToggleModeButton gamemodeHardcoreButton;
    protected CycleButton<Boolean> allowCheatsButton;
    protected CycleButton<Difficulty> difficultyButton;
    protected Button experimentsButton;

    public ModernWorldCreationGameTab(@NotNull CreateWorldScreen parent) {
        super(TITLE);
        this.font = Minecraft.getInstance().font;
        WorldCreationUiState uiState = Objects.requireNonNull(((IMixinCreateWorldScreen)parent).get_uiState_ModernWorldCreation());
        GridLayout.RowHelper rowHelper = this.layout.rowSpacing(8).createRowHelper(1);
        LayoutSettings layoutSettings = rowHelper.newCellSettings();
        this.nameEdit = new EditBox(this.font, 208, 20, (Component)Component.translatable((String)"selectWorld.enterName"));
        this.nameEdit.setValue(uiState.getName());
        this.nameEdit.setResponder(arg_0 -> ((WorldCreationUiState)uiState).setName(arg_0));
        uiState.addListener(worldCreationUiState -> this.nameEdit.setTooltip(Tooltip.create((Component)Component.translatable((String)"selectWorld.targetFolder", (Object[])new Object[]{Component.literal((String)worldCreationUiState.getTargetFolder()).withStyle(ChatFormatting.ITALIC)}))));
        ((IMixinScreen)parent).invoke_setInitialFocus_ModernWorldCreation((GuiEventListener)this.nameEdit);
        rowHelper.addChild((LayoutElement)CommonLayouts.labeledElement((Font)this.font, (LayoutElement)this.nameEdit, (Component)NAME_LABEL), rowHelper.newCellSettings().alignHorizontallyCenter());
        this.difficultyButton = (CycleButton)rowHelper.addChild((LayoutElement)CycleButton.builder(Difficulty::getDisplayName).withValues((Object[])Difficulty.values()).create(0, 0, 150, 20, (Component)Component.translatable((String)"options.difficulty"), (cycleButtonx, difficulty) -> uiState.setDifficulty(difficulty)), layoutSettings);
        uiState.addListener(worldCreationUiState -> {
            this.difficultyButton.setValue((Object)uiState.getDifficulty());
            this.difficultyButton.active = !uiState.isHardcore();
            this.difficultyButton.setTooltip(Tooltip.create((Component)uiState.getDifficulty().getInfo()));
        });
        this.allowCheatsButton = (CycleButton)rowHelper.addChild((LayoutElement)CycleButton.onOffBuilder().withTooltip(boolean_ -> Tooltip.create((Component)ALLOW_COMMANDS_INFO)).create(0, 0, 150, 20, ALLOW_COMMANDS, (cycleButtonx, boolean_) -> uiState.setAllowCommands(boolean_.booleanValue())));
        uiState.addListener(worldCreationUiState -> {
            this.allowCheatsButton.setValue((Object)uiState.isAllowCommands());
            this.allowCheatsButton.active = !uiState.isDebug() && !uiState.isHardcore();
        });
        if (!SharedConstants.getCurrentVersion().isStable()) {
            this.experimentsButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)EXPERIMENTS_LABEL, button -> ((IMixinCreateWorldScreen)parent).invoke_openExperimentsScreen_ModernWorldCreation(uiState.getSettings().dataConfiguration())).width(150).build());
        }
        ((ExtendedCreateWorldScreen)parent).setOnInitBody_ModernWorldCreation(screen -> {
            TabNavigationBar navigationBar = ((IMixinCreateWorldScreen)parent).get_tabNavigationBar_ModernWorldCreation();
            TabManager tabManager = ((IMixinTabNavigationBar)navigationBar).get_tabManager_ModernWorldCreation();
            if (!((ExtendedTabManager)tabManager).hasTabChangeListener_ModernWorldCreation()) {
                ((ExtendedTabManager)tabManager).setTabChangeListener_ModernWorldCreation(tab -> {
                    if (tab != this) {
                        ModernWorldCreationGameTab.removeScreenWidget((Screen)parent, (AbstractWidget)this.gamemodeSurvivalButton);
                        ModernWorldCreationGameTab.removeScreenWidget((Screen)parent, (AbstractWidget)this.gamemodeCreativeButton);
                        ModernWorldCreationGameTab.removeScreenWidget((Screen)parent, (AbstractWidget)this.gamemodeHardcoreButton);
                        ModernWorldCreationGameTab.removeScreenWidget((Screen)parent, (AbstractWidget)this.arrowLeftButton);
                        ModernWorldCreationGameTab.removeScreenWidget((Screen)parent, (AbstractWidget)this.arrowRightButton);
                    } else {
                        parent.repositionElements();
                    }
                });
            }
            if (tabManager.getCurrentTab() != this) {
                return;
            }
            int midX = screen.width / 2;
            int topY = this.nameEdit.getY();
            ModernWorldCreationGameTab.removeScreenWidget((Screen)screen, (AbstractWidget)this.arrowLeftButton);
            this.arrowLeftButton = ModernWorldCreationGameTab.addRenderableWidgetToScreen((Screen)screen, new ArrowButton(midX - 145 - 40 - 10, topY + 38 + 22 - 20, ArrowButton.ArrowDirection.LEFT, button -> this.switchToNextGameMode(uiState, ArrowButton.ArrowDirection.LEFT)));
            if (FMUtils.isFancyMenuLoaded()) {
                FMAccess.setUniqueIdentifierToWidget(this.arrowLeftButton, "mwc_arrow_left_button");
            }
            ModernWorldCreationGameTab.removeScreenWidget((Screen)screen, (AbstractWidget)this.arrowRightButton);
            this.arrowRightButton = ModernWorldCreationGameTab.addRenderableWidgetToScreen((Screen)screen, new ArrowButton(midX + 55 + 90 + 10, topY + 38 + 22 - 20, ArrowButton.ArrowDirection.RIGHT, button -> this.switchToNextGameMode(uiState, ArrowButton.ArrowDirection.RIGHT)));
            if (FMUtils.isFancyMenuLoaded()) {
                FMAccess.setUniqueIdentifierToWidget(this.arrowRightButton, "mwc_arrow_right_button");
            }
            WorldCreationUiState.SelectedGameMode selectedGamemode = uiState.getGameMode();
            ModernWorldCreationGameTab.removeScreenWidget((Screen)screen, (AbstractWidget)this.gamemodeSurvivalButton);
            this.gamemodeSurvivalButton = ModernWorldCreationGameTab.addRenderableWidgetToScreen((Screen)screen, new ToggleModeButton(parent, midX - 145, topY + 38, 90, 45, BUTTON_TEXTURE_SURVIVAL, SURVIVAL_LABEL, button -> this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.SURVIVAL)));
            this.gamemodeSurvivalButton.setInfoTooltip(List.of(WorldCreationUiState.SelectedGameMode.SURVIVAL.getInfo()));
            if (selectedGamemode == WorldCreationUiState.SelectedGameMode.SURVIVAL) {
                this.gamemodeSurvivalButton.setSelected(true);
            }
            if (FMUtils.isFancyMenuLoaded()) {
                FMAccess.setUniqueIdentifierToWidget(this.gamemodeSurvivalButton, "mwc_gamemode_survival_button");
            }
            ModernWorldCreationGameTab.removeScreenWidget((Screen)screen, (AbstractWidget)this.gamemodeCreativeButton);
            this.gamemodeCreativeButton = ModernWorldCreationGameTab.addRenderableWidgetToScreen((Screen)screen, new ToggleModeButton(parent, midX - 45, topY + 38, 90, 45, BUTTON_TEXTURE_CREATIVE, CREATIVE_LABEL, button -> this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.CREATIVE)));
            this.gamemodeCreativeButton.setInfoTooltip(List.of(WorldCreationUiState.SelectedGameMode.CREATIVE.getInfo()));
            if (selectedGamemode == WorldCreationUiState.SelectedGameMode.CREATIVE) {
                this.gamemodeCreativeButton.setSelected(true);
            }
            if (FMUtils.isFancyMenuLoaded()) {
                FMAccess.setUniqueIdentifierToWidget(this.gamemodeCreativeButton, "mwc_gamemode_creative_button");
            }
            ModernWorldCreationGameTab.removeScreenWidget((Screen)screen, (AbstractWidget)this.gamemodeHardcoreButton);
            this.gamemodeHardcoreButton = ModernWorldCreationGameTab.addRenderableWidgetToScreen((Screen)screen, new ToggleModeButton(parent, midX + 55, topY + 38, 90, 45, BUTTON_TEXTURE_HARDCORE, HARDCORE_LABEL, button -> this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.HARDCORE)));
            this.gamemodeHardcoreButton.setInfoTooltip(List.of(WorldCreationUiState.SelectedGameMode.HARDCORE.getInfo()));
            if (selectedGamemode == WorldCreationUiState.SelectedGameMode.HARDCORE) {
                this.gamemodeHardcoreButton.setSelected(true);
            }
            if (FMUtils.isFancyMenuLoaded()) {
                FMAccess.setUniqueIdentifierToWidget(this.gamemodeHardcoreButton, "mwc_gamemode_hardcore_button");
            }
            this.gamemodeSurvivalButton.setShowInfo(ModernWorldCreation.getOptions().showGameModeInfo.getValue());
            this.gamemodeCreativeButton.setShowInfo(ModernWorldCreation.getOptions().showGameModeInfo.getValue());
            this.gamemodeHardcoreButton.setShowInfo(ModernWorldCreation.getOptions().showGameModeInfo.getValue());
            this.difficultyButton.setX(midX - this.difficultyButton.getWidth() - 4);
            this.difficultyButton.setY(topY + 38 + 50 + 10);
            this.allowCheatsButton.setX(midX + 4);
            this.allowCheatsButton.setY(topY + 38 + 50 + 10);
            if (this.experimentsButton != null) {
                this.experimentsButton.setX(midX - this.experimentsButton.getWidth() / 2);
                this.experimentsButton.setY(this.difficultyButton.getY() + this.difficultyButton.getHeight() + 5);
            }
            if (screen.height - this.allowCheatsButton.getY() >= 100) {
                this.gamemodeSurvivalButton.setY(this.gamemodeSurvivalButton.getY() + 10);
                this.gamemodeCreativeButton.setY(this.gamemodeCreativeButton.getY() + 10);
                this.gamemodeHardcoreButton.setY(this.gamemodeHardcoreButton.getY() + 10);
                this.arrowLeftButton.setY(this.arrowLeftButton.getY() + 10);
                this.arrowRightButton.setY(this.arrowRightButton.getY() + 10);
                this.difficultyButton.setY(this.difficultyButton.getY() + 20);
                this.allowCheatsButton.setY(this.allowCheatsButton.getY() + 20);
                if (this.experimentsButton != null) {
                    this.experimentsButton.setY(this.experimentsButton.getY() + 20);
                }
            }
        });
    }

    protected void switchToNextGameMode(@NotNull WorldCreationUiState uiState, @NotNull ArrowButton.ArrowDirection direction) {
        if (direction == ArrowButton.ArrowDirection.LEFT) {
            if (uiState.getGameMode() == WorldCreationUiState.SelectedGameMode.SURVIVAL) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.HARDCORE);
            } else if (uiState.getGameMode() == WorldCreationUiState.SelectedGameMode.CREATIVE) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.SURVIVAL);
            } else if (uiState.getGameMode() == WorldCreationUiState.SelectedGameMode.HARDCORE) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.CREATIVE);
            }
        }
        if (direction == ArrowButton.ArrowDirection.RIGHT) {
            if (uiState.getGameMode() == WorldCreationUiState.SelectedGameMode.SURVIVAL) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.CREATIVE);
            } else if (uiState.getGameMode() == WorldCreationUiState.SelectedGameMode.CREATIVE) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.HARDCORE);
            } else if (uiState.getGameMode() == WorldCreationUiState.SelectedGameMode.HARDCORE) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.SURVIVAL);
            }
        }
    }

    protected void setGameMode(@NotNull WorldCreationUiState uiState, @NotNull WorldCreationUiState.SelectedGameMode gameMode) {
        uiState.setGameMode(gameMode);
        if (uiState.getGameMode() == WorldCreationUiState.SelectedGameMode.SURVIVAL) {
            this.gamemodeSurvivalButton.setSelected(true);
            this.gamemodeCreativeButton.setSelected(false);
            this.gamemodeHardcoreButton.setSelected(false);
        } else if (uiState.getGameMode() == WorldCreationUiState.SelectedGameMode.CREATIVE) {
            this.gamemodeSurvivalButton.setSelected(false);
            this.gamemodeCreativeButton.setSelected(true);
            this.gamemodeHardcoreButton.setSelected(false);
        } else if (uiState.getGameMode() == WorldCreationUiState.SelectedGameMode.HARDCORE) {
            this.gamemodeSurvivalButton.setSelected(false);
            this.gamemodeCreativeButton.setSelected(false);
            this.gamemodeHardcoreButton.setSelected(true);
        }
    }

    protected static <T extends AbstractWidget> T addRenderableWidgetToScreen(@NotNull Screen screen, @NotNull T widget) {
        ((IMixinScreen)screen).get_renderables_ModernWorldCreation().add((Renderable)widget);
        ((IMixinScreen)screen).get_children_ModernWorldCreation().add((GuiEventListener)widget);
        ((IMixinScreen)screen).get_narratables_ModernWorldCreation().add((NarratableEntry)widget);
        return widget;
    }

    protected static void removeScreenWidget(@NotNull Screen screen, @Nullable AbstractWidget widget) {
        if (widget == null) {
            return;
        }
        ((IMixinScreen)screen).get_renderables_ModernWorldCreation().remove(widget);
        ((IMixinScreen)screen).get_children_ModernWorldCreation().remove(widget);
        ((IMixinScreen)screen).get_narratables_ModernWorldCreation().remove(widget);
    }
}

