/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import java.util.ArrayList;
import java.util.List;
import me.desht.modularrouters.client.gui.filter.AbstractFilterScreen;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.item.smartfilter.InspectionFilter;
import me.desht.modularrouters.logic.filter.matchers.InspectionMatcher;
import me.desht.modularrouters.network.messages.FilterUpdateMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.Range;

public class InspectionFilterScreen
extends AbstractFilterScreen {
    private static final ResourceLocation TEXTURE_LOCATION = MiscUtil.RL("textures/gui/inspectionfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 191;
    private int xPos;
    private int yPos;
    private InspectionMatcher.ComparisonList comparisonList;
    private IntegerTextField valueTextField;
    private InspectionMatcher.InspectionSubject currentSubject = InspectionMatcher.InspectionSubject.NONE;
    private InspectionMatcher.InspectionOp currentOp = InspectionMatcher.InspectionOp.NONE;
    private final List<Buttons.DeleteButton> deleteButtons = new ArrayList<Buttons.DeleteButton>();
    private Button matchButton;

    public InspectionFilterScreen(ItemStack filterStack, MFLocator locator) {
        super(filterStack, locator);
        this.comparisonList = InspectionFilter.getComparisonList(filterStack);
    }

    public void init() {
        super.init();
        this.xPos = (this.width - 176) / 2;
        this.yPos = (this.height - 191) / 2;
        if (this.locator.filterSlot() >= 0) {
            this.addRenderableWidget((GuiEventListener)new BackButton(this.xPos - 12, this.yPos, button -> this.closeGUI()));
        }
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.xPos + 8, this.yPos + 22, 90, 20, (Component)ClientUtil.xlate(this.currentSubject.getTranslationKey(), new Object[0]), button -> {
            this.currentSubject = this.currentSubject.cycle(Screen.hasShiftDown() ? -1 : 1);
            button.setMessage((Component)ClientUtil.xlate(this.currentSubject.getTranslationKey(), new Object[0]));
        }));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.xPos + 95, this.yPos + 22, 20, 20, (Component)ClientUtil.xlate(this.currentOp.getTranslationKey(), new Object[0]), button -> {
            this.currentOp = this.currentOp.cycle(Screen.hasShiftDown() ? -1 : 1);
            button.setMessage((Component)ClientUtil.xlate(this.currentOp.getTranslationKey(), new Object[0]));
        }));
        this.addRenderableWidget((GuiEventListener)new Buttons.AddButton(this.xPos + 152, this.yPos + 23, button -> this.addEntry()));
        this.matchButton = new ExtendedButton(this.xPos + 8, this.yPos + 167, 60, 20, (Component)ClientUtil.xlate("modularrouters.guiText.label.matchAll." + this.comparisonList.matchAll(), new Object[0]), button -> {
            ItemStack newStack = (ItemStack)Util.make((Object)this.filterStack.copy(), s -> InspectionFilter.setComparisonList(s, this.comparisonList.setMatchAll(!this.comparisonList.matchAll())));
            PacketDistributor.sendToServer((CustomPacketPayload)new FilterUpdateMessage(this.locator, newStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        this.addRenderableWidget((GuiEventListener)this.matchButton);
        this.deleteButtons.clear();
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.xPos + 8, this.yPos + 52 + i * 19, i, button -> this.removeEntry(button.getId()));
            this.addRenderableWidget((GuiEventListener)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
        this.valueTextField = new IntegerTextField(this.font, this.xPos + 120, this.yPos + 28, 20, 14, Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100))){

            @Override
            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 257 || keyCode == 335) {
                    InspectionFilterScreen.this.addEntry();
                    return true;
                }
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
        };
        this.valueTextField.useGuiTextBackground();
        this.addRenderableWidget((GuiEventListener)this.valueTextField);
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).visible = i < this.comparisonList.items().size();
        }
    }

    private void addEntry() {
        if (this.currentOp != InspectionMatcher.InspectionOp.NONE && this.currentSubject != InspectionMatcher.InspectionSubject.NONE) {
            InspectionMatcher.Comparison newEntry = new InspectionMatcher.Comparison(this.currentSubject, this.currentOp, this.valueTextField.getIntValue());
            ItemStack newStack = (ItemStack)Util.make((Object)this.filterStack.copy(), s -> InspectionFilter.setComparisonList(s, this.comparisonList.addComparison(newEntry)));
            PacketDistributor.sendToServer((CustomPacketPayload)new FilterUpdateMessage(this.locator, newStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.valueTextField.setValue("");
        }
    }

    private void removeEntry(int pos) {
        ItemStack newStack = (ItemStack)Util.make((Object)this.filterStack.copy(), s -> InspectionFilter.setComparisonList(s, this.comparisonList.removeAt(pos)));
        PacketDistributor.sendToServer((CustomPacketPayload)new FilterUpdateMessage(this.locator, newStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(this.font, this.title, this.xPos + 88 - this.font.width((FormattedText)this.title) / 2, this.yPos + 6, 0x404040, false);
        for (int i = 0; i < this.comparisonList.items().size(); ++i) {
            InspectionMatcher.Comparison comparison = this.comparisonList.items().get(i);
            graphics.drawString(this.font, (Component)comparison.asLocalizedText(), this.xPos + 28, this.yPos + 55 + i * 19, 0x404080, false);
        }
    }

    public void renderBackground(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.blit(TEXTURE_LOCATION, this.xPos, this.yPos, 0, 0, 176, 191);
    }

    @Override
    public void resync(ItemStack stack) {
        this.comparisonList = InspectionFilter.getComparisonList(stack);
        this.matchButton.setMessage((Component)ClientUtil.xlate("modularrouters.guiText.label.matchAll." + this.comparisonList.matchAll(), new Object[0]));
        this.updateDeleteButtonVisibility();
    }
}

