/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CompiledDropperModule
extends CompiledModule {
    private final int pickupDelay = this.getAugmentCount((Supplier<Item>)ModItems.PICKUP_DELAY_AUGMENT) * 10;

    public CompiledDropperModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        ItemStack stack = router.getBufferItemStack();
        if (this.getFilter().test(stack) && this.isRegulationOK(router, false)) {
            int nItems = Math.min(this.getItemsPerTick(router), stack.getCount() - this.getRegulationAmount());
            if (nItems <= 0) {
                return false;
            }
            ItemStack toDrop = router.peekBuffer(nItems);
            BlockPos pos = this.getTarget().gPos.pos();
            Direction face = this.getTarget().face;
            ItemEntity item = new ItemEntity(router.nonNullLevel(), (double)pos.getX() + 0.5 + 0.2 * (double)face.getStepX(), (double)pos.getY() + 0.5 + 0.2 * (double)face.getStepY(), (double)pos.getZ() + 0.5 + 0.2 * (double)face.getStepZ(), toDrop);
            item.setPickUpDelay(this.pickupDelay);
            this.setupItemVelocity(router, item);
            router.nonNullLevel().addFreshEntity((Entity)item);
            router.extractBuffer(toDrop.getCount());
            return true;
        }
        return false;
    }

    void setupItemVelocity(ModularRouterBlockEntity router, ItemEntity item) {
        item.setDeltaMovement(0.0, 0.0, 0.0);
    }
}

