/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids;

import com.portingdeadmods.moofluids.ColorUtils;
import com.portingdeadmods.moofluids.MFConfig;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public final class FluidUtils {
    public static ConcurrentHashMap<ResourceLocation, Integer> colorCache = new ConcurrentHashMap();

    public static int getFluidColor(Fluid fluid) {
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation location = renderProperties.getStillTexture();
        int tint = renderProperties.getTintColor();
        int textureColor = 0;
        try {
            textureColor = colorCache.computeIfAbsent(location, ColorUtils::getColorFrom);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FastColor.ARGB32.multiply((int)textureColor, (int)tint);
    }

    public static boolean isFluidBlacklisted(Fluid fluid) {
        String fluidId = BuiltInRegistries.FLUID.getKey((Object)fluid).toString();
        String namespace = BuiltInRegistries.FLUID.getKey((Object)fluid).getNamespace();
        ArrayList<String> blackListedMods = new ArrayList<String>();
        for (String blackListedFluid : MFConfig.fluidBlacklist) {
            if (!blackListedFluid.contains("*")) continue;
            blackListedMods.add(blackListedFluid.split(":")[0]);
        }
        return MFConfig.fluidBlacklist.contains(fluidId) || blackListedMods.contains(namespace);
    }
}

