/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.block.entity;

import com.portingdeadmods.moofluids.MFConfig;
import com.portingdeadmods.moofluids.block.FluidCowJarBlock;
import com.portingdeadmods.moofluids.block.entity.MFBlockEntities;
import com.portingdeadmods.moofluids.data.CowJarDataComponent;
import com.portingdeadmods.moofluids.entity.FluidCow;
import com.portingdeadmods.moofluids.items.FluidCowJarBlockItem;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FluidCowJarBlockEntity
extends BlockEntity {
    private static final int UPDATE_INTERVAL = 20;
    private static final String TAG_FLUID_COW_FLUID = "FluidCowFluid";
    private static final String TAG_HAS_COW = "HasCow";
    private static final String TAG_CUSTOM_NAME = "CustomName";
    private static final String TAG_FLUID_TANK = "FluidTank";
    private static final String TAG_MILKING_COOLDOWN = "MilkingCooldown";
    private static final String TAG_CAN_BE_MILKED = "CanBeMilked";
    protected final FluidTank fluidTank = new FluidTank(MFConfig.COW_JAR_CAPACITY.getAsInt()){

        protected void onContentsChanged() {
            FluidCowJarBlockEntity.this.setChanged();
            if (FluidCowJarBlockEntity.this.level != null && !((FluidCowJarBlockEntity)FluidCowJarBlockEntity.this).level.isClientSide) {
                FluidCowJarBlockEntity.this.level.sendBlockUpdated(FluidCowJarBlockEntity.this.worldPosition, FluidCowJarBlockEntity.this.getBlockState(), FluidCowJarBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private Fluid cowFluid = Fluids.EMPTY;
    private boolean hasCow = false;
    private boolean isDirty;
    private int ticksSinceUpdate;
    private Component customName;
    private int milkingCooldown = 0;
    private boolean canBeMilked = true;

    public FluidCowJarBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)MFBlockEntities.FLUID_COW_JAR.get(), pos, state);
    }

    public FluidCowJarBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        CompoundTag tankTag = new CompoundTag();
        this.fluidTank.writeToNBT(registries, tankTag);
        tag.put(TAG_FLUID_TANK, (Tag)tankTag);
        if (this.cowFluid != Fluids.EMPTY) {
            tag.putString(TAG_FLUID_COW_FLUID, BuiltInRegistries.FLUID.getKey((Object)this.cowFluid).toString());
        }
        tag.putBoolean(TAG_HAS_COW, this.hasCow);
        if (this.customName != null) {
            tag.putString(TAG_CUSTOM_NAME, Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
        tag.putInt(TAG_MILKING_COOLDOWN, this.milkingCooldown);
        tag.putBoolean(TAG_CAN_BE_MILKED, this.canBeMilked);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        ResourceLocation fluidResourceLocation;
        String fluidName;
        super.loadAdditional(tag, registries);
        if (tag.contains(TAG_FLUID_TANK)) {
            this.fluidTank.readFromNBT(registries, tag.getCompound(TAG_FLUID_TANK));
        }
        if (!(fluidName = tag.getString(TAG_FLUID_COW_FLUID)).isEmpty() && (fluidResourceLocation = ResourceLocation.tryParse((String)fluidName)) != null) {
            this.cowFluid = (Fluid)BuiltInRegistries.FLUID.get(fluidResourceLocation);
            if (this.cowFluid == null) {
                this.cowFluid = Fluids.EMPTY;
            }
        }
        this.hasCow = tag.getBoolean(TAG_HAS_COW);
        if (tag.contains(TAG_CUSTOM_NAME)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString(TAG_CUSTOM_NAME), (HolderLookup.Provider)registries);
        }
        this.milkingCooldown = tag.getInt(TAG_MILKING_COOLDOWN);
        this.canBeMilked = tag.getBoolean(TAG_CAN_BE_MILKED);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FluidCowJarBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        FluidStack toAdd;
        int filled;
        if (this.hasCow && this.cowFluid != Fluids.EMPTY && this.fluidTank.getFluidAmount() < MFConfig.COW_JAR_CAPACITY.getAsInt() && (filled = this.fluidTank.fill(toAdd = new FluidStack(this.cowFluid, 1), IFluidHandler.FluidAction.EXECUTE)) > 0) {
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            level.sendBlockUpdated(pos, state, state, 3);
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public boolean addFluidCow(FluidCow cow) {
        if (!this.hasCow) {
            this.cowFluid = cow.getFluid();
            this.hasCow = true;
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                int lightLevel = this.cowFluid.getFluidType().getLightLevel();
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)FluidCowJarBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(lightLevel)), 3);
            }
            return true;
        }
        return false;
    }

    public void removeFluidCow() {
        this.hasCow = false;
        this.cowFluid = Fluids.EMPTY;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)FluidCowJarBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    public boolean hasCow() {
        return this.hasCow;
    }

    public Fluid getCowFluid() {
        return this.cowFluid;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public Component getCustomName() {
        return this.customName;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component getDefaultName() {
        if (this.hasCow) {
            return Component.translatable((String)"block.moofluids.fluid_cow_jar_filled");
        }
        return Component.translatable((String)"block.moofluids.fluid_cow_jar");
    }

    public boolean canBeMilked() {
        return true;
    }

    public int getMilkingCooldown() {
        return 0;
    }

    public void saveToItem(ItemStack stack, HolderLookup.Provider registries) {
        super.saveToItem(stack, registries);
        stack.set(FluidCowJarBlockItem.FLUID_TANK.get(), (Object)SimpleFluidContent.copyOf((FluidStack)this.getFluidTank().getFluid()));
        stack.set(FluidCowJarBlockItem.COW_JAR_DATA.get(), (Object)new CowJarDataComponent(this.hasCow(), this.getCowFluid(), this.getFluidTank().getCapacity()));
    }

    public void loadFromItem(CowJarDataComponent cowData, SimpleFluidContent fluidContent) {
        this.hasCow = cowData.hasCow();
        this.cowFluid = cowData.fluid();
        if (fluidContent != null && !fluidContent.isEmpty()) {
            this.fluidTank.setFluid(fluidContent.copy());
        }
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            int lightLevel = this.hasCow && this.cowFluid != Fluids.EMPTY ? this.cowFluid.getFluidType().getLightLevel() : 0;
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)FluidCowJarBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(lightLevel)), 3);
        }
    }
}

