/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.compat.jei;

import com.portingdeadmods.moofluids.compat.jei.FluidCowBreedingRecipe;
import com.portingdeadmods.moofluids.compat.jei.FluidCowBreedingRecipeProvider;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidBreedingRecipeManagerPlugin
implements ISimpleRecipeManagerPlugin<FluidCowBreedingRecipe> {
    public boolean isHandledInput(ITypedIngredient<?> ingredient) {
        if (ingredient.getType() == NeoForgeTypes.FLUID_STACK) {
            return true;
        }
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            ItemStack itemStack = (ItemStack)ingredient.getIngredient();
            return this.getFluidFromItem(itemStack) != null;
        }
        return false;
    }

    public boolean isHandledOutput(ITypedIngredient<?> ingredient) {
        if (ingredient.getType() == NeoForgeTypes.FLUID_STACK) {
            return true;
        }
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            ItemStack itemStack = (ItemStack)ingredient.getIngredient();
            return this.getFluidFromItem(itemStack) != null;
        }
        return false;
    }

    public List<FluidCowBreedingRecipe> getRecipesForInput(ITypedIngredient<?> input) {
        Fluid fluid = this.extractFluid(input);
        if (fluid != null) {
            return FluidCowBreedingRecipeProvider.getAllRecipes().stream().filter(recipe -> recipe.getParent1().equals(fluid) || recipe.getParent2().equals(fluid)).toList();
        }
        return List.of();
    }

    public List<FluidCowBreedingRecipe> getRecipesForOutput(ITypedIngredient<?> output) {
        Fluid fluid = this.extractFluid(output);
        if (fluid != null) {
            return FluidCowBreedingRecipeProvider.getAllRecipes().stream().filter(recipe -> recipe.getResult().equals(fluid)).toList();
        }
        return List.of();
    }

    public List<FluidCowBreedingRecipe> getAllRecipes() {
        return FluidCowBreedingRecipeProvider.getAllRecipes();
    }

    private Fluid extractFluid(ITypedIngredient<?> ingredient) {
        if (ingredient.getType() == NeoForgeTypes.FLUID_STACK) {
            FluidStack fluidStack = (FluidStack)ingredient.getIngredient();
            return fluidStack.getFluid();
        }
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            ItemStack itemStack = (ItemStack)ingredient.getIngredient();
            return this.getFluidFromItem(itemStack);
        }
        return null;
    }

    private Fluid getFluidFromItem(ItemStack itemStack) {
        Item item;
        IFluidHandler fluidHandler = (IFluidHandler)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null) {
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                FluidStack fluidInTank = fluidHandler.getFluidInTank(i);
                if (fluidInTank.isEmpty()) continue;
                return fluidInTank.getFluid();
            }
        }
        if ((item = itemStack.getItem()) instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            return bucketItem.content;
        }
        return null;
    }
}

