/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.items;

import com.portingdeadmods.moofluids.FluidUtils;
import com.portingdeadmods.moofluids.data.CowJarDataComponent;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class FluidCowJarBlockItem
extends BlockItem {
    public static final DeferredRegister.DataComponents DATA_COMPONENTS = DeferredRegister.createDataComponents((String)"moofluids");
    public static final Supplier<DataComponentType<CowJarDataComponent>> COW_JAR_DATA = DATA_COMPONENTS.registerComponentType("cow_jar_data", builder -> builder.persistent(CowJarDataComponent.CODEC).networkSynchronized(CowJarDataComponent.STREAM_CODEC));
    public static final Supplier<DataComponentType<SimpleFluidContent>> FLUID_TANK = DATA_COMPONENTS.registerComponentType("fluid_tank", builder -> builder.persistent(SimpleFluidContent.CODEC).networkSynchronized(SimpleFluidContent.STREAM_CODEC));

    public FluidCowJarBlockItem(Block block, Item.Properties properties) {
        super(block, properties.component(COW_JAR_DATA, (Object)new CowJarDataComponent(false, Fluids.EMPTY, 0)).component(FLUID_TANK, (Object)SimpleFluidContent.EMPTY));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        int color;
        FluidStack fluidStack;
        super.appendHoverText(stack, context, tooltip, flag);
        CowJarDataComponent cowJarDataComponent = (CowJarDataComponent)stack.get(COW_JAR_DATA.get());
        Fluid fluid = cowJarDataComponent.fluid();
        if (fluid != Fluids.EMPTY) {
            fluidStack = new FluidStack(fluid, 1);
            color = FluidUtils.getFluidColor(fluid);
            tooltip.add((Component)Component.translatable((String)"tooltip.moofluids.fluid_cow_jar.contains", (Object[])new Object[]{fluidStack.getDisplayName().copy().setStyle(Style.EMPTY.withColor(color))}));
            if (FluidUtils.isFluidBlacklisted(fluid)) {
                tooltip.add((Component)Component.translatable((String)"tooltip.moofluids.fluid_cow_jar.blacklisted").withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.moofluids.fluid_cow_jar.release").withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.moofluids.fluid_cow_jar.hint").withStyle(ChatFormatting.GRAY));
        }
        fluidStack = ((SimpleFluidContent)stack.get(FLUID_TANK)).copy();
        if (!fluidStack.isEmpty()) {
            color = FluidUtils.getFluidColor(fluidStack.getFluid());
            tooltip.add((Component)Component.translatable((String)"tooltip.moofluids.fluid_cow_jar.fluid", (Object[])new Object[]{fluidStack.getDisplayName().copy().setStyle(Style.EMPTY.withColor(color))}));
            tooltip.add((Component)Component.translatable((String)"tooltip.moofluids.fluid_cow_jar.amount", (Object[])new Object[]{fluidStack.getAmount()}));
        }
    }
}

