/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.moofluids.MFConfig;
import com.portingdeadmods.moofluids.MooFluids;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record FluidCowSpawnBiomeModifier(HolderSet<Biome> biomes, List<MobSpawnSettings.SpawnerData> spawners, List<String> blacklistedBiomes, List<String> whitelistedBiomes) implements BiomeModifier
{
    public static final MapCodec<FluidCowSpawnBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(FluidCowSpawnBiomeModifier::biomes), (App)MobSpawnSettings.SpawnerData.CODEC.listOf().fieldOf("spawners").forGetter(FluidCowSpawnBiomeModifier::spawners), (App)Codec.STRING.listOf().lenientOptionalFieldOf("blacklisted_biomes", List.of()).forGetter(FluidCowSpawnBiomeModifier::blacklistedBiomes), (App)Codec.STRING.listOf().lenientOptionalFieldOf("whitelisted_biomes", List.of()).forGetter(FluidCowSpawnBiomeModifier::whitelistedBiomes)).apply((Applicative)instance, FluidCowSpawnBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.ADD) {
            return;
        }
        if (!this.biomes.contains(biome)) {
            return;
        }
        if (!MFConfig.naturalSpawning) {
            return;
        }
        ResourceLocation biomeId = biome.unwrapKey().map(ResourceKey::location).orElse(null);
        if (biomeId == null) {
            return;
        }
        if (this.shouldBlockSpawn(biome, biomeId)) {
            return;
        }
        MobSpawnSettingsBuilder spawnSettings = builder.getMobSpawnSettings();
        for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
            EntityType type = spawner.type;
            spawnSettings.addSpawn(type.getCategory(), spawner);
        }
    }

    private boolean shouldBlockSpawn(Holder<Biome> biome, ResourceLocation biomeId) {
        List<String> blacklist = MFConfig.biomeSpawnBlacklist;
        List<String> whitelist = MFConfig.biomeSpawnWhitelist;
        if (!whitelist.isEmpty()) {
            boolean isWhitelisted = false;
            for (String entry : whitelist) {
                if (entry.startsWith("#")) {
                    if (!this.isBiomeInTag(biome, entry.substring(1))) continue;
                    isWhitelisted = true;
                    break;
                }
                if (!biomeId.toString().equals(entry)) continue;
                isWhitelisted = true;
                break;
            }
            if (!isWhitelisted) {
                return true;
            }
        }
        for (String entry : blacklist) {
            if (!(entry.startsWith("#") ? this.isBiomeInTag(biome, entry.substring(1)) : biomeId.toString().equals(entry))) continue;
            return true;
        }
        return false;
    }

    private boolean isBiomeInTag(Holder<Biome> biomeHolder, String tagId) {
        try {
            ResourceLocation tagLocation = ResourceLocation.parse((String)tagId);
            ResourceKey tagKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tagLocation);
            return biomeHolder.is(tagKey);
        }
        catch (Exception e) {
            MooFluids.LOGGER.error("Failed to check biome tag: {}", (Object)tagId, (Object)e);
            return false;
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

