/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import java.util.ArrayList;
import java.util.HashSet;
import net.mehvahdjukaar.moonlight.core.commands.DebugRenderersCommand;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.common.custom.NeighborUpdatesDebugPayload;
import net.minecraft.network.protocol.common.custom.PathfindingDebugPayload;
import net.minecraft.network.protocol.common.custom.StructuresDebugPayload;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.Target;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugPackets.class})
public abstract class DebugPacketsMixin {
    @Shadow
    private static void sendPacketToAllPlayers(ServerLevel level, CustomPacketPayload payload) {
    }

    @Inject(method={"sendPathFindingPacket(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/level/pathfinder/Path;F)V"}, at={@At(value="HEAD")})
    private static void ml$sendPathfindingDebug(Level level, Mob mob, @Nullable Path path, float maxDistanceToWaypoint, CallbackInfo ci) {
        if (path != null && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!DebugRenderersCommand.DEBUG_PATHFINDING.isActive(mob.getType(), (Level)sl)) {
                return;
            }
            Path.DebugData debugData = path.debugData();
            if (debugData == null) {
                ArrayList<Node> close = new ArrayList<Node>();
                ArrayList<Node> open = new ArrayList<Node>();
                HashSet<Target> targets = new HashSet<Target>();
                for (int i = 0; i < path.getNodeCount(); ++i) {
                    Node node = path.getNode(i);
                    if (node.closed) {
                        close.add(node);
                        continue;
                    }
                    open.add(node);
                }
                BlockPos pos = path.getTarget();
                Target t = mob.getNavigation().getNodeEvaluator().getTarget((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                targets.add(t);
                path.setDebug(open.toArray(new Node[0]), close.toArray(new Node[0]), targets);
                debugData = path.debugData();
            }
            if (debugData != null && !debugData.targetNodes().isEmpty()) {
                DebugPacketsMixin.sendPacketToAllPlayers(sl, (CustomPacketPayload)new PathfindingDebugPayload(mob.getId(), path, maxDistanceToWaypoint));
            }
        }
    }

    @Inject(method={"sendNeighborsUpdatePacket(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")})
    private static void ml$neighborUpdatesDebug(Level level, BlockPos pos, CallbackInfo ci) {
        if (DebugRenderersCommand.DEBUG_NEIGHBOR_UPDATES && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            DebugPacketsMixin.sendPacketToAllPlayers(sl, (CustomPacketPayload)new NeighborUpdatesDebugPayload(level.getGameTime(), pos));
        }
    }

    @Inject(method={"sendGoalSelector(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/entity/ai/goal/GoalSelector;)V"}, at={@At(value="HEAD")})
    private static void ml$goalDebug(Level level, Mob mob, GoalSelector goalSelector, CallbackInfo ci) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!DebugRenderersCommand.DEBUG_GOAL_SELECTOR.isActive(mob.getType(), (Level)sl)) {
                return;
            }
            ArrayList<GoalDebugPayload.DebugGoal> goals = new ArrayList<GoalDebugPayload.DebugGoal>();
            for (WrappedGoal g : goalSelector.getAvailableGoals()) {
                goals.add(new GoalDebugPayload.DebugGoal(g.getPriority(), g.isRunning(), g.getGoal().toString()));
            }
            DebugPacketsMixin.sendPacketToAllPlayers(sl, (CustomPacketPayload)new GoalDebugPayload(mob.getId(), mob.blockPosition(), goals));
        }
    }

    @Inject(method={"sendStructurePacket(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/levelgen/structure/StructureStart;)V"}, at={@At(value="HEAD")})
    private static void ml$StructureDebug(WorldGenLevel level, StructureStart structureStart, CallbackInfo ci) {
        ServerLevel sl = level.getLevel();
        if (!DebugRenderersCommand.DEBUG_STRUCTURES_BB.isActive(structureStart.getStructure(), (Level)sl)) {
            return;
        }
        ArrayList<StructuresDebugPayload.PieceInfo> infos = new ArrayList<StructuresDebugPayload.PieceInfo>();
        for (StructurePiece s : structureStart.getPieces()) {
            infos.add(new StructuresDebugPayload.PieceInfo(s.getBoundingBox(), s.getGenDepth() <= 0));
        }
        DebugPacketsMixin.sendPacketToAllPlayers(sl, (CustomPacketPayload)new StructuresDebugPayload(sl.dimension(), structureStart.getBoundingBox(), infos));
    }
}

