/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.id;

import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.block.OnCableConnectorBlock;
import com.tom.morewires.compat.id.IDConnectorBlockEntity;
import java.util.Collection;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class IDConnectorBlock
extends OnCableConnectorBlock<IDConnectorBlockEntity> {
    public IDConnectorBlock(DeferredHolder<BlockEntityType<?>, BlockEntityType<IDConnectorBlockEntity>> type, BiPredicate<BlockGetter, BlockPos> isOnCable) {
        super(type, isOnCable);
    }

    public void onPlace(BlockState blockState, Level world, BlockPos blockPos, BlockState oldState, boolean isMoving) {
        super.onPlace(blockState, world, blockPos, oldState, isMoving);
        if (!world.isClientSide()) {
            CableHelpers.onCableAdded((Level)world, (BlockPos)blockPos);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide()) {
            CableHelpers.onCableAddedByPlayer((Level)world, (BlockPos)pos, (LivingEntity)placer);
        }
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        CableHelpers.onCableRemoving((Level)((Level)world), (BlockPos)blockPos, (boolean)true, (boolean)false, (BlockState)blockState);
        Collection connectedCables = CableHelpers.getExternallyConnectedCables((Level)((Level)world), (BlockPos)blockPos);
        super.destroy(world, blockPos, blockState);
        CableHelpers.onCableRemoved((Level)((Level)world), (BlockPos)blockPos, (Collection)connectedCables);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos blockPos, Explosion explosion) {
        CableHelpers.setRemovingCable((boolean)true);
        CableHelpers.onCableRemoving((Level)world, (BlockPos)blockPos, (boolean)true, (boolean)false, (BlockState)state);
        Collection connectedCables = CableHelpers.getExternallyConnectedCables((Level)world, (BlockPos)blockPos);
        super.onBlockExploded(state, world, blockPos, explosion);
        CableHelpers.onCableRemoved((Level)world, (BlockPos)blockPos, (Collection)connectedCables);
        CableHelpers.setRemovingCable((boolean)false);
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, world, pos, neighborBlock, fromPos, isMoving);
        NetworkHelpers.onElementProviderBlockNeighborChange((Level)world, (BlockPos)pos, (Block)neighborBlock, null, (BlockPos)fromPos);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world instanceof Level) {
            NetworkHelpers.onElementProviderBlockNeighborChange((Level)((Level)world), (BlockPos)pos, (Block)world.getBlockState(neighbor).getBlock(), null, (BlockPos)neighbor);
        }
    }

    public void onRemove(BlockState oldState, Level world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (oldState.getBlock() != newState.getBlock()) {
            Collection connectedCables = null;
            if (!CableHelpers.isRemovingCable()) {
                CableHelpers.onCableRemoving((Level)world, (BlockPos)blockPos, (boolean)true, (boolean)false, (BlockState)oldState);
                connectedCables = CableHelpers.getExternallyConnectedCables((Level)world, (BlockPos)blockPos);
            }
            super.onRemove(oldState, world, blockPos, newState, isMoving);
            if (!CableHelpers.isRemovingCable()) {
                CableHelpers.onCableRemoved((Level)world, (BlockPos)blockPos, (Collection)connectedCables);
            }
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : (blockEntityType == MoreImmersiveWires.ID_WIRE.simple().CONNECTOR_ENTITY.get() ? new IDConnectorBlockEntity.Ticker() : null);
    }
}

