/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay;

import at.ridgo8.moreoverlays.api.lightoverlay.LightScannerBase;
import at.ridgo8.moreoverlays.config.Config;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.ModList;

public class LightScannerVanilla
extends LightScannerBase {
    private static final AABB TEST_BB = new AABB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);
    private static boolean ChiselsAndBits = false;
    private static boolean ChiselsAndBitsCheckDone = false;
    private final List<EntityType<?>> typesToCheck = BuiltInRegistries.ENTITY_TYPE.stream().filter(type -> type.canSummon() && type.getCategory() == MobCategory.MONSTER).collect(Collectors.toList());

    private static boolean checkCollision(BlockPos pos, Level world) {
        BlockState block1 = world.getBlockState(pos);
        if (block1.isCollisionShapeFullBlock((BlockGetter)world, pos) || !((Boolean)Config.light_IgnoreLayer.get()).booleanValue() && world.getBlockState(pos.above()).isCollisionShapeFullBlock((BlockGetter)world, pos.above())) {
            return false;
        }
        if (world.isEmptyBlock(pos) && (((Boolean)Config.light_IgnoreLayer.get()).booleanValue() || world.isEmptyBlock(pos.above()))) {
            return true;
        }
        AABB bb = TEST_BB.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        boolean hasCollision = world.getBlockCollisions(null, bb).iterator().hasNext();
        if (!hasCollision && !world.containsAnyLiquid(bb)) {
            if (((Boolean)Config.light_IgnoreLayer.get()).booleanValue()) {
                return true;
            }
            AABB bb2 = bb.move(0.0, 1.0, 0.0);
            boolean hasCollision2 = world.getBlockCollisions(null, bb2).iterator().hasNext();
            return !hasCollision2 && !world.containsAnyLiquid(bb2);
        }
        return false;
    }

    private static boolean isChiselsAndBitsLoaded() {
        if (!ChiselsAndBitsCheckDone) {
            ChiselsAndBits = ModList.get().isLoaded("chiselsandbits");
            ChiselsAndBitsCheckDone = true;
        }
        return ChiselsAndBits;
    }

    @Override
    public byte getSpawnModeAt(BlockPos pos, Level world) {
        if (world.getBrightness(LightLayer.BLOCK, pos) >= (Integer)Config.light_SaveLevel.get()) {
            return 0;
        }
        BlockPos blockPos = pos.below();
        if (world.isEmptyBlock(blockPos)) {
            return 0;
        }
        if (world.containsAnyLiquid(new AABB(blockPos))) {
            return 0;
        }
        if (LightScannerVanilla.isChiselsAndBitsLoaded() && world.getBlockState(blockPos).getBlock().getName().getString().contains("chiselsandbits")) {
            return 0;
        }
        if (!LightScannerVanilla.checkCollision(pos, world)) {
            return 0;
        }
        if (!((Boolean)Config.light_SimpleEntityCheck.get()).booleanValue()) {
            boolean hasSpawnable = false;
            for (EntityType<?> type : this.typesToCheck) {
                if (!SpawnPlacementTypes.ON_GROUND.isSpawnPositionOk((LevelReader)world, pos, type)) continue;
                hasSpawnable = true;
                break;
            }
            if (!hasSpawnable) {
                return 0;
            }
        } else if (!SpawnPlacementTypes.ON_GROUND.isSpawnPositionOk((LevelReader)world, pos, EntityType.ZOMBIE)) {
            return 0;
        }
        if (world.getBrightness(LightLayer.SKY, pos) >= (Integer)Config.light_SaveLevel.get()) {
            return 1;
        }
        return 2;
    }
}

