/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.entity.brain;

import io.github.irishgreencitrus.occultengineering.content.entity.brain.DynamicBrain;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBrains;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBrainFactory<T extends LivingEntity> {
    Function<T, ? extends DynamicBrain<T>> constructor;
    Class<T> entityClass;

    public DynamicBrainFactory(Function<T, ? extends DynamicBrain<T>> constructor, Class<T> entityClass) {
        this.constructor = constructor;
        this.entityClass = entityClass;
    }

    public DynamicBrain<T> create(T entity) {
        DynamicBrain<T> brain = this.constructor.apply(entity);
        brain.brainID = OccultEngineeringBrains.REGISTRY.getKey((Object)this);
        return brain;
    }

    public boolean canCreateFor(@NotNull Class<?> cls) {
        return this.entityClass.isAssignableFrom(cls);
    }

    @Nullable
    public DynamicBrain<? extends LivingEntity> create(Entity entity) {
        if (!this.canCreateFor(this.entityClass)) {
            return null;
        }
        DynamicBrain<T> brain = this.constructor.apply((LivingEntity)entity);
        brain.brainID = OccultEngineeringBrains.REGISTRY.getKey((Object)this);
        return brain;
    }
}

