/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.tterrag.registrate.providers.RegistrateGenericProvider;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.datagen.book.EnUsProvider;
import io.github.irishgreencitrus.occultengineering.datagen.book.OcEngBookProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;

public class UnifiedBookProvider
implements RegistrateGenericProvider.Generator,
DataProvider {
    PackOutput output;
    CompletableFuture<HolderLookup.Provider> registries;
    public static Map<String, String> bookData;

    public UnifiedBookProvider(RegistrateGenericProvider.GeneratorData data) {
        this.output = data.output();
        this.registries = data.registries();
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        if (this.output == null || this.registries == null) {
            throw new IllegalStateException("Must be generated after event");
        }
        OccultEngineering.LOGGER.info("Running Unified Book Provider");
        EnUsProvider bookLang = new EnUsProvider(this.output);
        BookProvider bookProvider = new BookProvider(this.output, this.registries, "occultengineering", List.of(new OcEngBookProvider((ModonomiconLanguageProvider)bookLang)));
        CompletableFuture bookFutures = bookProvider.run(cachedOutput);
        bookFutures.join();
        OccultEngineering.LOGGER.info("Book has {} lang entries", (Object)bookLang.data().size());
        bookData = bookLang.data();
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String getName() {
        return "Occult Engineering - Unified Book Provider";
    }

    public DataProvider generate(RegistrateGenericProvider.GeneratorData data) {
        this.output = data.output();
        OccultEngineering.LOGGER.info("Output is {}", (Object)this.output);
        this.registries = data.registries();
        OccultEngineering.LOGGER.info("Registries is {}", this.registries);
        return this;
    }
}

