/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.registry;

import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.simibubi.create.AllFluids;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.config.OccultEngineeringConfig;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringTags;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Vector3f;

public class OccultEngineeringFluids {
    public static final FluidEntry<BaseFlowingFluid.Flowing> SPIRIT_SOLUTION = ((FluidBuilder)OccultEngineering.REGISTRATE.standardFluid("spirit_solution", SolidRenderedPlaceableFluidType.create(12983807, () -> Float.valueOf(0.125f * OccultEngineeringConfig.client().spiritSolutionTransparencyMultiplier.getF()))).lang("Spirit Solution").properties(b -> b.viscosity(500).density(500)).tag(new TagKey[]{OccultEngineeringTags.SPIRIT_SOLUTION_FLUID}).tag(new TagKey[]{OccultEngineeringTags.PUCALITH_FUEL}).source(BaseFlowingFluid.Source::new).bucket().build()).register();

    public static void register() {
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(SPIRIT_SOLUTION.getType(), fluidState -> {
            if (fluidState.isSource()) {
                return Blocks.OBSIDIAN.defaultBlockState();
            }
            return ((Block)OccultismBlocks.OTHERSTONE.get()).defaultBlockState();
        }));
    }

    private static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }
}

