/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity.glowlayer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.ClientUtil;

public class ConditionalGlowingGeoLayer<T extends GeoAnimatable>
extends GeoRenderLayer<T> {
    public ConditionalGlowingGeoLayer(GeoRenderer<T> renderer) {
        super(renderer);
    }

    @Nullable
    protected RenderType getRenderType(T animatable) {
        if (!(animatable instanceof Entity)) {
            return AutoGlowingTexture.getRenderType((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
        }
        Entity entity = (Entity)animatable;
        boolean invisible = entity.isInvisible();
        ResourceLocation texture = AutoGlowingTexture.getEmissiveResource((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
        if (Minecraft.getInstance().getResourceManager().getResource(texture).isEmpty()) {
            return null;
        }
        if (invisible && !entity.isInvisibleTo(ClientUtil.getClientPlayer())) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)texture);
        }
        if (Minecraft.getInstance().shouldEntityAppearGlowing(entity)) {
            if (invisible) {
                return RenderType.outline((ResourceLocation)texture);
            }
            return AutoGlowingTexture.getOutlineRenderType((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
        }
        return invisible ? null : AutoGlowingTexture.getRenderType((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        renderType = this.getRenderType(animatable);
        if (renderType != null) {
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, animatable, renderType, bufferSource.getBuffer(renderType), partialTick, 0xF00000, packedOverlay, this.getRenderer().getRenderColor(animatable, partialTick, packedLight).argbInt());
        }
    }
}

