/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import com.klikli_dev.occultism.api.common.data.ColorBlockState;
import com.klikli_dev.occultism.crafting.recipe.SpiritFireRecipe;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.klikli_dev.occultism.util.EnumUtil;
import com.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SpiritFireBlock
extends BaseFireBlock {
    public static final EnumProperty<ColorBlockState> COLOR = EnumProperty.create((String)"color", ColorBlockState.class);
    public static final MapCodec<SpiritFireBlock> CODEC = SpiritFireBlock.simpleCodec(SpiritFireBlock::new);
    protected Supplier<Integer> color;

    public SpiritFireBlock(BlockBehaviour.Properties properties) {
        super(properties, 0.0f);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(COLOR, (Comparable)((Object)ColorBlockState.WHITE)));
    }

    protected MapCodec<? extends BaseFireBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.defaultBlockState();
    }

    protected boolean canBurn(BlockState pState) {
        return true;
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)pEntity;
            SingleRecipeInput recipeInput = new SingleRecipeInput(item.getItem());
            Optional recipe = pLevel.getRecipeManager().getRecipeFor((RecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get(), (RecipeInput)recipeInput, pLevel);
            if (recipe.isPresent() && !item.isRemoved()) {
                item.remove(Entity.RemovalReason.DISCARDED);
                ItemStack result = ((SpiritFireRecipe)((RecipeHolder)recipe.get()).value()).assemble(recipeInput, (HolderLookup.Provider)pLevel.registryAccess());
                Vec3 center = Math3DUtil.center(pPos);
                Containers.dropItemStack((Level)pLevel, (double)center.x, (double)(center.y + 0.5), (double)center.z, (ItemStack)result);
                pLevel.playSound(null, pPos, OccultismSounds.START_RITUAL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLOR});
        super.createBlockStateDefinition(builder);
    }

    public int getColor(BlockState state, int i) {
        return i == 1 ? SpiritFireBlock.mixColors(this.getColor(state, 0), 0xFFFFFF, 0.4f) : EnumUtil.getConfiguredColor(((ColorBlockState)((Object)state.getValue(COLOR))).getNumber());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getAbilities().mayBuild) {
            Item item = stack.getItem();
            if (item.equals(OccultismItems.CHALK_WHITE.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.WHITE)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_LIGHT_GRAY.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.LIGHT_GRAY)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_GRAY.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.GRAY)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_BLACK.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.BLACK)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_BROWN.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.BROWN)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_RED.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.RED)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_ORANGE.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.ORANGE)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_YELLOW.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.YELLOW)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_LIME.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.LIME)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_GREEN.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.GREEN)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_CYAN.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.CYAN)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_LIGHT_BLUE.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.LIGHT_BLUE)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_BLUE.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.BLUE)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_PURPLE.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.PURPLE)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_MAGENTA.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.MAGENTA)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_PINK.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.PINK)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_RAINBOW.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.RAINBOW)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (item.equals(OccultismItems.CHALK_VOID.get())) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)((Object)ColorBlockState.VOID)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) ? pState : Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos below = pos.below();
        return worldIn.getBlockState(below).isFaceSturdy((BlockGetter)worldIn, pos, Direction.UP);
    }

    private static int mixColors(int color1, int color2, float w) {
        int a1 = color1 >> 24;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        return ((int)((float)a1 + (float)(a2 - a1) * w) << 24) + ((int)((float)r1 + (float)(r2 - r1) * w) << 16) + ((int)((float)g1 + (float)(g2 - g1) * w) << 8) + ((int)((float)b1 + (float)(b2 - b1) * w) << 0);
    }
}

