/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block.storage;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.block.OtherstoneFrameBlock;
import com.klikli_dev.occultism.common.blockentity.StableWormholeBlockEntity;
import com.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.klikli_dev.occultism.common.item.storage.StableWormholeBlockItem;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.BlockEntityUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StableWormholeBlock
extends OtherstoneFrameBlock
implements EntityBlock {
    public static final Property<Boolean> LINKED = BooleanProperty.create((String)"linked");

    public StableWormholeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(LINKED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        StableWormholeBlockEntity wormhole;
        BlockEntity blockEntity;
        if (((Boolean)Occultism.SERVER_CONFIG.storage.unlinkWormholeOnBreak.get()).booleanValue() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof StableWormholeBlockEntity && (wormhole = (StableWormholeBlockEntity)blockEntity).getLinkedStorageController() != null) {
            wormhole.setLinkedStorageControllerPosition(null);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof StableWormholeBlockEntity) {
            StableWormholeBlockEntity wormhole = (StableWormholeBlockEntity)blockEntity;
            if (StorageControllerContainerBase.canOpen(pPlayer, pPos) && pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                if (wormhole.getLinkedStorageController() != null) {
                    serverPlayer.openMenu((MenuProvider)wormhole, pPos);
                    StorageControllerContainerBase.reserve(pPlayer, pPos);
                } else if (((Boolean)pLevel.getBlockState(pPos).getValue(LINKED)).booleanValue() && !wormhole.controllerLoaded()) {
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)(((StableWormholeBlockItem)((Object)OccultismItems.STABLE_WORMHOLE.get())).getDescriptionId() + ".message.not_loaded")));
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace());
        if (context.getItemInHand().has(OccultismDataComponents.LINKED_STORAGE_CONTROLLER)) {
            state = (BlockState)state.setValue(LINKED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public ItemStack getCloneItemStack(LevelReader worldIn, BlockPos pos, BlockState state) {
        return BlockEntityUtil.getItemWithNbt(this, worldIn, pos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LINKED});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return OccultismBlockEntities.STABLE_WORMHOLE.get().create(blockPos, blockState);
    }
}

