/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.storage;

import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.common.blockentity.StableWormholeBlockEntity;
import com.klikli_dev.occultism.common.blockentity.StorageControllerBlockEntity;
import com.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageUpdateLinkedMachines;
import com.klikli_dev.occultism.registry.OccultismContainers;
import com.klikli_dev.occultism.util.BlockEntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class StableWormholeContainer
extends StorageControllerContainerBase {
    protected StorageControllerBlockEntity storageController;
    protected StableWormholeBlockEntity stableWormhole;

    public StableWormholeContainer(int id, Inventory playerInventory, StableWormholeBlockEntity stableWormhole) {
        super(OccultismContainers.STABLE_WORMHOLE.get(), id, playerInventory);
        this.stableWormhole = stableWormhole;
        this.storageController = (StorageControllerBlockEntity)stableWormhole.getLinkedStorageController();
        this.matrix = new StorageControllerCraftingInventory((AbstractContainerMenu)this, stableWormhole.getMatrix());
        this.orderInventory.setItem(0, this.stableWormhole.getOrderStack());
        this.setupCraftingOutput();
        this.setupCraftingGrid();
        this.setupOrderInventorySlot();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
        this.slotsChanged((Container)this.matrix);
    }

    public StableWormholeBlockEntity getStableWormhole() {
        return this.stableWormhole;
    }

    @Override
    public StorageControllerBlockEntity getStorageController() {
        return this.storageController;
    }

    @Override
    public GlobalBlockPos getStorageControllerGlobalBlockPos() {
        return this.stableWormhole.getLinkedStorageControllerPosition();
    }

    @Override
    public boolean isContainerItem() {
        return false;
    }

    @Override
    public void updateCraftingSlots(boolean force) {
        for (int i = 0; i < 9; ++i) {
            this.stableWormhole.getMatrix().put(i, this.matrix.getItem(i));
        }
        if (force) {
            this.stableWormhole.markNetworkDirty();
        }
    }

    @Override
    public void updateOrderSlot(boolean force) {
        this.stableWormhole.setOrderStack(this.orderInventory.getItem(0));
        if (force) {
            this.stableWormhole.markNetworkDirty();
        }
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.result && super.canTakeItemForPickAll(stack, slot);
    }

    public boolean stillValid(Player player) {
        BlockPos wormholePosition;
        if (this.storageController == null || this.stableWormhole == null) {
            return false;
        }
        Level level = this.stableWormhole.getLevel();
        if (level.getBlockEntity(wormholePosition = this.stableWormhole.getBlockPos()) != this.stableWormhole) {
            return false;
        }
        if (BlockEntityUtil.get(level, this.stableWormhole.getLinkedStorageControllerPosition()) != this.storageController) {
            return false;
        }
        if (!level.isClientSide && level.getGameTime() % 40L == 0L) {
            Networking.sendTo((ServerPlayer)player, this.storageController.getMessageUpdateStacks());
            Networking.sendTo((ServerPlayer)player, new MessageUpdateLinkedMachines(this.storageController.getLinkedMachines()));
        }
        return player.distanceToSqr((double)wormholePosition.getX() + 0.5, (double)wormholePosition.getY() + 0.5, (double)wormholePosition.getZ() + 0.5) <= 64.0;
    }
}

