/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.storage;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.klikli_dev.occultism.common.item.storage.StorageRemoteItem;
import com.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageUpdateLinkedMachines;
import com.klikli_dev.occultism.registry.OccultismContainers;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.util.CuriosUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class StorageRemoteContainer
extends StorageControllerContainerBase {
    protected int selectedSlot;

    public StorageRemoteContainer(int id, Inventory playerInventory, int selectedSlot) {
        super(OccultismContainers.STORAGE_REMOTE.get(), id, playerInventory);
        this.playerInventory = playerInventory;
        this.selectedSlot = selectedSlot;
        this.matrix = new StorageControllerCraftingInventory((AbstractContainerMenu)this, this.getCraftingMatrixFromItemStack(this.getStorageRemote()));
        this.orderInventory.setItem(0, this.getOrderStackFromItemStack(this.getStorageRemote()));
        this.setupCraftingOutput();
        this.setupCraftingGrid();
        this.setupOrderInventorySlot();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
        this.slotsChanged((Container)this.matrix);
    }

    public ItemStack getStorageRemote() {
        if (this.selectedSlot == -1) {
            return CuriosUtil.getStorageRemoteCurio(this.player);
        }
        if (this.selectedSlot < 0 || this.selectedSlot >= this.player.getInventory().getContainerSize()) {
            return ItemStack.EMPTY;
        }
        ItemStack selected = this.player.getInventory().getItem(this.selectedSlot);
        return selected.getItem() instanceof StorageRemoteItem ? selected : ItemStack.EMPTY;
    }

    @Override
    public GlobalBlockPos getStorageControllerGlobalBlockPos() {
        ItemStack storageRemote = this.getStorageRemote();
        return storageRemote != ItemStack.EMPTY ? (GlobalBlockPos)storageRemote.get(OccultismDataComponents.LINKED_STORAGE_CONTROLLER) : null;
    }

    @Override
    protected void setupPlayerHotbar() {
        int hotbarTop = 119;
        int hotbarLeft = 56;
        for (int i = 0; i < 9; ++i) {
            if (i == this.selectedSlot) {
                this.addSlot(new Slot(this, (Container)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop){

                    public boolean mayPlace(ItemStack stack) {
                        return false;
                    }

                    public boolean hasItem() {
                        return false;
                    }

                    public boolean mayPickup(Player playerIn) {
                        return false;
                    }
                });
                continue;
            }
            this.addSlot(new Slot((Container)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    @Override
    protected void setupPlayerInventorySlots() {
        int playerInventoryTop = 61;
        int playerInventoryLeft = 56;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (j + i * 9 + 9 == this.selectedSlot) {
                    this.addSlot(new Slot(this, (Container)this.playerInventory, j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18){

                        public boolean mayPlace(ItemStack stack) {
                            return false;
                        }

                        public boolean hasItem() {
                            return false;
                        }

                        public boolean mayPickup(Player playerIn) {
                            return false;
                        }
                    });
                    continue;
                }
                this.addSlot(new Slot((Container)this.playerInventory, j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    public boolean stillValid(Player entityPlayer) {
        IStorageController storageController = this.getStorageController();
        if (storageController != null && !entityPlayer.level().isClientSide && entityPlayer.level().getGameTime() % 40L == 0L) {
            Networking.sendTo((ServerPlayer)this.player, this.getStorageController().getMessageUpdateStacks());
            Networking.sendTo((ServerPlayer)this.player, new MessageUpdateLinkedMachines(this.getStorageController().getLinkedMachines()));
        }
        return storageController != null && this.getStorageRemote() != ItemStack.EMPTY;
    }

    @Override
    public IStorageController getStorageController() {
        return StorageRemoteItem.getStorageController(this.getStorageRemote(), this.playerInventory.player.level());
    }

    @Override
    public boolean isContainerItem() {
        return true;
    }

    @Override
    public void updateCraftingSlots(boolean force) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.matrix.getContainerSize(); ++i) {
            nbtTagList.add((Object)this.matrix.getItem(i).saveOptional((HolderLookup.Provider)this.player.registryAccess()));
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("craftingMatrix", (Tag)nbtTagList);
        ItemStack storageRemote = this.getStorageRemote();
        if (storageRemote != ItemStack.EMPTY) {
            storageRemote.set(OccultismDataComponents.CRAFTING_MATRIX, (Object)CustomData.of((CompoundTag)compoundTag));
        }
    }

    @Override
    public void updateOrderSlot(boolean force) {
        ItemStack storageRemote = this.getStorageRemote();
        if (storageRemote != ItemStack.EMPTY) {
            storageRemote.set(OccultismDataComponents.ORDER_STACK, (Object)CustomData.of((CompoundTag)((CompoundTag)this.orderInventory.getItem(0).saveOptional((HolderLookup.Provider)this.player.registryAccess()))));
        }
    }

    protected List<ItemStack> getCraftingMatrixFromItemStack(ItemStack stack) {
        ArrayList<ItemStack> craftingMatrix = new ArrayList<ItemStack>(Collections.nCopies(9, ItemStack.EMPTY));
        if (!stack.has(OccultismDataComponents.CRAFTING_MATRIX)) {
            return craftingMatrix;
        }
        ListTag nbtTagList = ((CustomData)stack.get(OccultismDataComponents.CRAFTING_MATRIX)).getUnsafe().getList("craftingMatrix", 10);
        for (int i = 0; i < nbtTagList.size(); ++i) {
            craftingMatrix.set(i, ItemStack.parseOptional((HolderLookup.Provider)this.player.registryAccess(), (CompoundTag)nbtTagList.getCompound(i)));
        }
        return craftingMatrix;
    }

    protected ItemStack getOrderStackFromItemStack(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.ORDER_STACK)) {
            return ItemStack.EMPTY;
        }
        return ItemStack.parseOptional((HolderLookup.Provider)this.player.registryAccess(), (CompoundTag)((CustomData)stack.get(OccultismDataComponents.ORDER_STACK)).copyTag());
    }
}

