/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.klikli_dev.occultism.common.entity.familiar.GuardianFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.HeadlessFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.registry.OccultismItems;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public abstract class FamiliarEntity
extends PathfinderMob
implements IFamiliar {
    private static final float MAX_BOOST_DISTANCE = 8.0f;
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BLACKSMITH_UPGRADE = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> VARIANTS = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private boolean partying;
    private BlockPos jukeboxPos;

    public FamiliarEntity(EntityType<? extends FamiliarEntity> type, Level level) {
        super(type, level);
        this.setPersistenceRequired();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ARMOR, 15.0).add(Attributes.ARMOR_TOUGHNESS, 10.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    protected void dropFromLootTable(DamageSource pDamageSource, boolean pAttackedRecently) {
        if (this.getFamiliarEntity() instanceof GuardianFamiliarEntity || this.getFamiliarEntity() instanceof HeadlessFamiliarEntity) {
            return;
        }
        super.dropFromLootTable(pDamageSource, pAttackedRecently);
        LivingEntity owner = this.getFamiliarOwner();
        ItemStack shard = new ItemStack((ItemLike)OccultismItems.SOUL_SHARD_ITEM.get());
        float health = this.getHealth();
        this.setHealth(this.getMaxHealth());
        this.resetFallDistance();
        this.removeAllEffects();
        CompoundTag entityData = new CompoundTag();
        String id = this.getEncodeId();
        if (id != null) {
            entityData.putString("id", id);
        }
        entityData = this.saveWithoutId(entityData);
        shard.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityData));
        this.setHealth(health);
        if (owner instanceof Player) {
            Player player = (Player)owner;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)shard);
        } else {
            ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), shard);
            entityitem.setPickUpDelay(5);
            entityitem.setDeltaMovement(entityitem.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            this.level().addFreshEntity((Entity)entityitem);
        }
    }

    public void setRecordPlayingNearby(BlockPos jukeboxPos, boolean partying) {
        this.jukeboxPos = jukeboxPos;
        this.partying = partying;
    }

    public boolean isPartying() {
        return this.partying;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SITTING, (Object)false);
        builder.define(BLACKSMITH_UPGRADE, (Object)false);
        builder.define(OWNER_UNIQUE_ID, Optional.empty());
        builder.define(VARIANTS, (Object)0);
    }

    public boolean hasBlacksmithUpgrade() {
        return (Boolean)this.entityData.get(BLACKSMITH_UPGRADE);
    }

    private void setBlacksmithUpgrade(boolean b) {
        this.entityData.set(BLACKSMITH_UPGRADE, (Object)b);
    }

    @Override
    public void blacksmithUpgrade() {
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.displayClientMessage((Component)Component.translatable((String)String.format("message.%s.familiar.upgraded", "occultism"), (Object[])new Object[]{this.getName()}), true);
        }
        if (!(this.getFamiliarEntity() instanceof GuardianFamiliarEntity)) {
            this.setCustomName((Component)Component.empty().append(this.getName()).append(" \u26e4"));
        }
        this.setBlacksmithUpgrade(true);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void aiStep() {
        LivingEntity owner;
        this.updateSwingTime();
        if (this.jukeboxPos == null || !this.jukeboxPos.closerThan((Vec3i)this.blockPosition(), 3.5) || !this.level().getBlockState(this.jukeboxPos).is(Blocks.JUKEBOX)) {
            this.partying = false;
            this.jukeboxPos = null;
        }
        if (!this.level().isClientSide && this.level().getGameTime() % 10L == 0L && (owner = this.getFamiliarOwner()) != null && this.distanceTo((Entity)owner) < 8.0f) {
            for (MobEffectInstance effect : this.getFamiliarEffects()) {
                owner.addEffect(effect);
            }
        }
        super.aiStep();
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerId();
        return uuid == null ? null : this.level().getPlayerByUUID(uuid);
    }

    protected InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = playerIn.getItemInHand(hand);
        if (stack.getItem() == OccultismItems.FAMILIAR_RING.get()) {
            return stack.interactLivingEntity(playerIn, (LivingEntity)this, hand);
        }
        if (stack.getItem() == OccultismItems.DEBUG_WAND.get() || this.getFamiliarOwner() == null) {
            this.setOwnerId(playerIn.getUUID());
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (stack.isEmpty() && !this.level().isClientSide && this.getFamiliarOwner() == playerIn) {
            this.setSitting(!this.isSitting());
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public LivingEntity getFamiliarOwner() {
        return this.getOwner();
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        this.setOwnerId(owner.getUUID());
    }

    public UUID getOwnerId() {
        return ((Optional)this.entityData.get(OWNER_UNIQUE_ID)).orElse(null);
    }

    private void setOwnerId(UUID id) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(id));
    }

    @Override
    public Entity getFamiliarEntity() {
        return this;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("owner")) {
            this.setOwnerId(compound.getUUID("owner"));
        }
        if (compound.contains("isSitting")) {
            this.setSitting(compound.getBoolean("isSitting"));
        }
        this.setBlacksmithUpgrade(compound.getBoolean("hasBlacksmithUpgrade"));
        this.entityData.set(VARIANTS, (Object)compound.getByte("variants"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getOwnerId() != null) {
            compound.putUUID("owner", this.getOwnerId());
        }
        compound.putBoolean("isSitting", this.isSitting());
        compound.putBoolean("hasBlacksmithUpgrade", this.hasBlacksmithUpgrade());
        compound.putByte("variants", ((Byte)this.entityData.get(VARIANTS)).byteValue());
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        return super.isInvulnerableTo(source) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.FLY_INTO_WALL);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    protected void setSitting(boolean b) {
        this.entityData.set(SITTING, (Object)b);
    }

    protected void setVariant(int offset, boolean b) {
        if (b) {
            this.entityData.set(VARIANTS, (Object)((byte)((Byte)this.entityData.get(VARIANTS) | 1 << offset)));
        } else {
            this.entityData.set(VARIANTS, (Object)((byte)((Byte)this.entityData.get(VARIANTS) & ~(1 << offset))));
        }
    }

    protected boolean hasVariant(int offset) {
        return ((Byte)this.entityData.get(VARIANTS) >> offset & 1) == 1;
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (target == owner) {
            return false;
        }
        if (target instanceof Creeper || target instanceof Ghast || target instanceof ArmorStand) {
            return false;
        }
        if (target instanceof Wolf) {
            Wolf wolf = (Wolf)target;
            return !wolf.isTame() || wolf.getOwner() != owner;
        }
        if (target instanceof Player) {
            Player player1;
            Player player = (Player)target;
            if (owner instanceof Player && !(player1 = (Player)owner).canHarmPlayer(player)) {
                return false;
            }
        }
        if (target instanceof AbstractHorse && (abstracthorse = (AbstractHorse)target).isTamed()) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)target).isTame();
    }

    public static class FamiliarPanicGoal
    extends PanicGoal {
        protected final FamiliarEntity entity;

        public FamiliarPanicGoal(FamiliarEntity mob, double speedModifier) {
            super((PathfinderMob)mob, speedModifier);
            this.entity = mob;
        }

        public void start() {
            this.entity.setSitting(false);
            this.mob.getNavigation().moveTo(this.posX, this.posY, this.posZ, this.speedModifier);
            this.isRunning = true;
        }
    }

    protected class SitGoal
    extends Goal {
        private final FamiliarEntity entity;

        public SitGoal(FamiliarEntity this$0, FamiliarEntity entity) {
            this.entity = entity;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !this.entity.isInWaterOrBubble() && this.entity.getFamiliarOwner() != null && this.entity.isSitting();
        }

        public void start() {
            this.entity.getNavigation().stop();
        }
    }

    protected static class FollowOwnerGoal
    extends Goal {
        private static final int TELEPORT_ATTEMPTS = 10;
        private final double speed;
        private final float maxDist;
        private final float minDist;
        protected FamiliarEntity entity;
        private int cooldown;
        private LivingEntity owner;

        public FollowOwnerGoal(FamiliarEntity entity, double speed, float minDist, float maxDist) {
            this.entity = entity;
            this.speed = speed;
            this.minDist = minDist * minDist;
            this.maxDist = maxDist * maxDist;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean shouldFollow(double distance) {
            return this.owner != null && !this.owner.isSpectator() && this.entity.distanceToSqr((Entity)this.owner) > distance;
        }

        public boolean canUse() {
            this.owner = this.entity.getFamiliarOwner();
            return this.shouldFollow(this.minDist);
        }

        public boolean canContinueToUse() {
            return this.shouldFollow(this.maxDist);
        }

        public void start() {
            this.cooldown = 0;
        }

        public void stop() {
            this.owner = null;
            this.entity.getNavigation().stop();
        }

        public void tick() {
            this.entity.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.entity.getMaxHeadXRot());
            if (--this.cooldown < 0) {
                this.cooldown = 10;
                if (!this.entity.isLeashed() && !this.entity.isPassenger()) {
                    if (this.entity.distanceToSqr((Entity)this.owner) >= 150.0 || this.shouldTeleport(this.owner)) {
                        this.tryTeleport();
                    } else {
                        this.entity.getNavigation().moveTo((Entity)this.owner, this.speed);
                    }
                }
            }
        }

        protected boolean shouldTeleport(LivingEntity owner) {
            return false;
        }

        private void tryTeleport() {
            for (int i = 0; i < 10; ++i) {
                if (!this.tryTeleport(this.randomNearby(this.owner.blockPosition()))) continue;
                return;
            }
        }

        private boolean tryTeleport(BlockPos pos) {
            boolean walkable = PathType.WALKABLE == WalkNodeEvaluator.getPathTypeStatic((Mob)this.entity, (BlockPos)pos.mutable());
            boolean noCollision = this.entity.level().noCollision((Entity)this.entity, this.entity.getBoundingBox().move(pos.subtract((Vec3i)this.entity.blockPosition())));
            if (walkable && noCollision) {
                this.entity.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, this.entity.yRotO, this.entity.xRotO);
                this.entity.navigation.stop();
                return true;
            }
            return false;
        }

        private BlockPos randomNearby(BlockPos pos) {
            RandomSource rand = this.entity.getRandom();
            return pos.offset(Mth.nextInt((RandomSource)rand, (int)-3, (int)3), Mth.nextInt((RandomSource)rand, (int)-1, (int)1), Mth.nextInt((RandomSource)rand, (int)-3, (int)3));
        }
    }
}

