/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.ai.goal.PickupItemsGoal;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityEvent;

public class SmelterJob
extends SpiritJob {
    public static final String DROPPED_BY_SMELTER = "occultism:dropped_by_smelter";
    protected int smeltingTimer;
    protected Supplier<Float> smeltingTimeMultiplier;
    protected Supplier<Integer> tier;
    protected Supplier<Integer> operationCount;
    protected Optional<RecipeHolder<SmeltingRecipe>> currentRecipe = Optional.empty();
    protected Optional<RecipeHolder<BlastingRecipe>> currentRecipeBlast = Optional.empty();
    protected Optional<RecipeHolder<SmokingRecipe>> currentRecipeSmoke = Optional.empty();
    protected Optional<RecipeHolder<CampfireCookingRecipe>> currentRecipeCamp = Optional.empty();
    protected PickupItemsGoal pickupItemsGoal;
    protected List<Ingredient> itemsToPickUp = new ArrayList<Ingredient>();

    public SmelterJob(SpiritEntity entity, Supplier<Float> smeltingTimeMultiplier, Supplier<Integer> operationCount) {
        super(entity);
        this.smeltingTimeMultiplier = smeltingTimeMultiplier;
        this.operationCount = operationCount;
    }

    @Override
    public void onInit() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.targetSelector.addGoal(1, (Goal)this.pickupItemsGoal);
        this.itemsToPickUp.addAll(this.entity.level().getRecipeManager().getAllRecipesFor(RecipeType.SMELTING).stream().flatMap(recipe -> ((SmeltingRecipe)recipe.value()).getIngredients().stream()).toList());
        this.itemsToPickUp.addAll(this.entity.level().getRecipeManager().getAllRecipesFor(RecipeType.BLASTING).stream().flatMap(recipe -> ((BlastingRecipe)recipe.value()).getIngredients().stream()).toList());
        this.itemsToPickUp.addAll(this.entity.level().getRecipeManager().getAllRecipesFor(RecipeType.SMOKING).stream().flatMap(recipe -> ((SmokingRecipe)recipe.value()).getIngredients().stream()).toList());
        this.itemsToPickUp.addAll(this.entity.level().getRecipeManager().getAllRecipesFor(RecipeType.CAMPFIRE_COOKING).stream().flatMap(recipe -> ((CampfireCookingRecipe)recipe.value()).getIngredients().stream()).toList());
    }

    @Override
    public void cleanup() {
        this.entity.targetSelector.removeGoal((Goal)this.pickupItemsGoal);
    }

    @Override
    public void update() {
        ItemStack handHeld = this.entity.getItemInHand(InteractionHand.MAIN_HAND);
        SingleRecipeInput recipeInput = new SingleRecipeInput(handHeld);
        if (!handHeld.isEmpty() && this.currentRecipe.isEmpty() && this.currentRecipeBlast.isEmpty() && this.currentRecipeSmoke.isEmpty() && this.currentRecipeCamp.isEmpty()) {
            this.currentRecipe = this.entity.level().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)recipeInput, this.entity.level());
            if (this.currentRecipe.isEmpty()) {
                this.currentRecipeBlast = this.entity.level().getRecipeManager().getRecipeFor(RecipeType.BLASTING, (RecipeInput)recipeInput, this.entity.level());
                if (this.currentRecipeBlast.isEmpty()) {
                    this.currentRecipeSmoke = this.entity.level().getRecipeManager().getRecipeFor(RecipeType.SMOKING, (RecipeInput)recipeInput, this.entity.level());
                    if (this.currentRecipeSmoke.isEmpty()) {
                        this.currentRecipeCamp = this.entity.level().getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)recipeInput, this.entity.level());
                    }
                }
            }
            this.smeltingTimer = 0;
            if (this.currentRecipe.isPresent() || this.currentRecipeBlast.isPresent() || this.currentRecipeSmoke.isPresent() || this.currentRecipeCamp.isPresent()) {
                this.entity.level().playSound(null, this.entity.blockPosition(), SoundEvents.FIRE_AMBIENT, SoundSource.NEUTRAL, 1.0f, 1.0f + 0.5f * this.entity.getRandom().nextFloat());
            } else {
                this.entity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                ItemEntity droppedItem = this.entity.spawnAtLocation(handHeld);
                if (droppedItem != null) {
                    droppedItem.addTag(DROPPED_BY_SMELTER);
                }
            }
        }
        if (this.currentRecipe.isPresent()) {
            if (handHeld.isEmpty() || !((SmeltingRecipe)this.currentRecipe.get().value()).matches(recipeInput, this.entity.level())) {
                this.currentRecipe = Optional.empty();
            } else {
                this.commomTick();
                if ((float)this.smeltingTimer >= (float)((SmeltingRecipe)this.currentRecipe.get().value()).getCookingTime() * this.smeltingTimeMultiplier.get().floatValue()) {
                    this.smeltingTimer = 0;
                    result = ((SmeltingRecipe)this.currentRecipe.get().value()).assemble(recipeInput, (HolderLookup.Provider)this.entity.level().registryAccess());
                    this.commonFinish(handHeld, result);
                }
            }
        } else if (this.currentRecipeBlast.isPresent()) {
            if (handHeld.isEmpty() || !((BlastingRecipe)this.currentRecipeBlast.get().value()).matches(recipeInput, this.entity.level())) {
                this.currentRecipeBlast = Optional.empty();
            } else {
                this.commomTick();
                if ((float)this.smeltingTimer >= (float)((BlastingRecipe)this.currentRecipeBlast.get().value()).getCookingTime() * this.smeltingTimeMultiplier.get().floatValue()) {
                    this.smeltingTimer = 0;
                    result = ((BlastingRecipe)this.currentRecipeBlast.get().value()).assemble(recipeInput, (HolderLookup.Provider)this.entity.level().registryAccess());
                    this.commonFinish(handHeld, result);
                }
            }
        } else if (this.currentRecipeSmoke.isPresent()) {
            if (handHeld.isEmpty() || !((SmokingRecipe)this.currentRecipeSmoke.get().value()).matches(recipeInput, this.entity.level())) {
                this.currentRecipeSmoke = Optional.empty();
            } else {
                this.commomTick();
                if ((float)this.smeltingTimer >= (float)((SmokingRecipe)this.currentRecipeSmoke.get().value()).getCookingTime() * this.smeltingTimeMultiplier.get().floatValue()) {
                    this.smeltingTimer = 0;
                    result = ((SmokingRecipe)this.currentRecipeSmoke.get().value()).assemble(recipeInput, (HolderLookup.Provider)this.entity.level().registryAccess());
                    this.commonFinish(handHeld, result);
                }
            }
        } else if (this.currentRecipeCamp.isPresent()) {
            if (handHeld.isEmpty() || !((CampfireCookingRecipe)this.currentRecipeCamp.get().value()).matches(recipeInput, this.entity.level())) {
                this.currentRecipeCamp = Optional.empty();
            } else {
                this.commomTick();
                if ((float)this.smeltingTimer >= (float)((CampfireCookingRecipe)this.currentRecipeCamp.get().value()).getCookingTime() * this.smeltingTimeMultiplier.get().floatValue()) {
                    this.smeltingTimer = 0;
                    result = ((CampfireCookingRecipe)this.currentRecipeCamp.get().value()).assemble(recipeInput, (HolderLookup.Provider)this.entity.level().registryAccess());
                    this.commonFinish(handHeld, result);
                }
            }
        }
        super.update();
    }

    private void commomTick() {
        ++this.smeltingTimer;
        if (this.entity.level().getGameTime() % 10L == 0L) {
            Vec3 pos = this.entity.position();
            ((ServerLevel)this.entity.level()).sendParticles((ParticleOptions)ParticleTypes.FLAME, pos.x + this.entity.level().random.nextGaussian() / 3.0, pos.y + 0.5, pos.z + this.entity.level().random.nextGaussian() / 3.0, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.smeltingTimer % 40 == 0) {
            this.entity.level().playSound(null, this.entity.blockPosition(), SoundEvents.FIRE_AMBIENT, SoundSource.NEUTRAL, 1.0f, 1.0f + 0.5f * this.entity.getRandom().nextFloat());
        }
    }

    private void commonFinish(ItemStack handHeld, ItemStack result) {
        ItemEntity droppedItem;
        int a = Math.min(this.operationCount.get(), handHeld.getCount());
        result.setCount(result.getCount() * a);
        ItemStack inputCopy = handHeld.copy();
        inputCopy.setCount(a);
        handHeld.shrink(a);
        this.onSmelt(inputCopy, result);
        SmelterJobEvent event = new SmelterJobEvent((Entity)this.entity, inputCopy, result);
        NeoForge.EVENT_BUS.post((Event)event);
        if (!event.getResult().isEmpty() && (droppedItem = this.entity.spawnAtLocation(event.getResult())) != null) {
            droppedItem.addTag(DROPPED_BY_SMELTER);
        }
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt("conversionTimer", this.smeltingTimer);
        return super.writeJobToNBT(compound, provider);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound, HolderLookup.Provider provider) {
        super.readJobFromNBT(compound, provider);
        this.smeltingTimer = compound.getInt("conversionTimer");
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        if (entity.getTags().contains(DROPPED_BY_SMELTER) && entity.getAge() < (Integer)Occultism.SERVER_CONFIG.spiritJobs.smelterResultPickupDelay.get()) {
            return false;
        }
        ItemStack stack = entity.getItem();
        return !stack.isEmpty() && this.itemsToPickUp.stream().anyMatch(i -> i.test(stack));
    }

    @Override
    public List<Ingredient> getItemsToPickUp() {
        return this.itemsToPickUp;
    }

    public void onSmelt(ItemStack input, ItemStack output) {
    }

    public static class SmelterJobEvent
    extends EntityEvent {
        private ItemStack input;
        private ItemStack result;

        public SmelterJobEvent(Entity entity, ItemStack input, ItemStack result) {
            super(entity);
            this.input = input;
            this.result = result;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public void setInput(ItemStack input) {
            this.input = input;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }
    }
}

