/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.level.multichunk;

import com.klikli_dev.occultism.common.level.multichunk.IMultiChunkSubFeature;
import com.klikli_dev.occultism.common.level.multichunk.MultiChunkFeatureConfig;
import com.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class MultiChunkFeature
extends Feature<MultiChunkFeatureConfig> {
    public final IMultiChunkSubFeature subFeature;

    public MultiChunkFeature(Codec<MultiChunkFeatureConfig> codec, IMultiChunkSubFeature subFeature) {
        super(codec);
        this.subFeature = subFeature;
    }

    public static long getLargeFeatureWithSaltSeed(long pLevelSeed, int pRegionX, int pRegionZ, int pSalt) {
        return (long)pRegionX * 341873128712L + (long)pRegionZ * 132897987541L + pLevelSeed + (long)pSalt;
    }

    protected List<BlockPos> getRootPositions(WorldGenLevel reader, ChunkGenerator generator, RandomSource random, ChunkPos generatingChunk, MultiChunkFeatureConfig config) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(1);
        for (int i = -config.maxChunksToRoot / 2; i < config.maxChunksToRoot / 2; ++i) {
            for (int j = -config.maxChunksToRoot / 2; j < config.maxChunksToRoot / 2; ++j) {
                ChunkPos currentChunk = new ChunkPos(generatingChunk.x + i, generatingChunk.z + j);
                long seed = MultiChunkFeature.getLargeFeatureWithSaltSeed(reader.getSeed(), currentChunk.x, currentChunk.z, config.featureSeedSalt);
                random.setSeed(seed);
                if (random.nextInt(config.chanceToGenerate) != 0) continue;
                result.add(currentChunk.getWorldPosition().offset(random.nextInt(15), Math.min(generator.getGenDepth(), config.minGenerationHeight + random.nextInt(Math.max(0, config.maxGenerationHeight - config.minGenerationHeight))), random.nextInt(15)));
            }
        }
        return result;
    }

    public boolean place(FeaturePlaceContext<MultiChunkFeatureConfig> context) {
        BlockPos pos = context.origin();
        ChunkSource chunkSource = context.level().getChunkSource();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache chunkSource2 = (ServerChunkCache)chunkSource;
            ChunkPos generatingChunk = new ChunkPos(pos);
            XoroshiroRandomSource random = new XoroshiroRandomSource(context.random().nextLong());
            List<BlockPos> rootPositions = this.getRootPositions(context.level(), context.chunkGenerator(), (RandomSource)random, generatingChunk, (MultiChunkFeatureConfig)context.config());
            if (rootPositions.isEmpty()) {
                return false;
            }
            boolean generatedAny = false;
            for (BlockPos rootPosition : rootPositions) {
                if (!this.subFeature.place(context.level(), context.chunkGenerator(), (RandomSource)random, rootPosition, Math3DUtil.bounds(generatingChunk, context.chunkGenerator().getGenDepth()), (MultiChunkFeatureConfig)context.config())) continue;
                generatedAny = true;
            }
            return generatedAny;
        }
        return false;
    }
}

