/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.ritual;

import com.klikli_dev.occultism.common.advancement.RitualTrigger;
import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.ritual.SummonRitual;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class FamiliarRitual
extends SummonRitual {
    public FamiliarRitual(RitualRecipe recipe) {
        super(recipe, true);
    }

    @Override
    public void finish(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable ServerPlayer castingPlayer, ItemStack activationItem) {
        Entity entity;
        level.playSound(null, goldenBowlPosition, OccultismSounds.POOF.get(), SoundSource.BLOCKS, 0.7f, 0.7f);
        if (castingPlayer != null) {
            castingPlayer.displayClientMessage((Component)Component.translatable((String)this.getFinishedMessage(castingPlayer)), true);
            ((RitualTrigger)((Object)OccultismAdvancements.RITUAL.get())).trigger(castingPlayer, this);
        }
        String entityName = ItemNBTUtil.getBoundSpiritName(activationItem);
        activationItem.shrink(1);
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)goldenBowlPosition.getX() + 0.5, (double)goldenBowlPosition.getY() + 0.5, (double)goldenBowlPosition.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        EntityType<?> entityType = this.recipe.getEntityToSummon();
        if (entityType != null && (entity = this.createSummonedEntity(entityType, level, goldenBowlPosition, blockEntity, (Player)castingPlayer)) instanceof FamiliarEntity) {
            FamiliarEntity familiar = (FamiliarEntity)entity;
            EventHooks.finalizeMobSpawn((Mob)familiar, (ServerLevelAccessor)((ServerLevelAccessor)level), (DifficultyInstance)level.getCurrentDifficultyAt(goldenBowlPosition), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null);
            this.applyEntityNbt((Entity)familiar);
            familiar.absMoveTo(goldenBowlPosition.getX(), goldenBowlPosition.getY(), goldenBowlPosition.getZ(), level.random.nextInt(360), 0.0f);
            familiar.setCustomName((Component)Component.literal((String)entityName));
            if (castingPlayer != null) {
                familiar.setFamiliarOwner((LivingEntity)castingPlayer);
            }
            this.spawnEntity((Entity)familiar, level);
        }
        ItemStack flame = OccultismItems.FLAME_AUTOMATION.toStack();
        ItemNBTUtil.setBoundSpiritName(flame, this.recipe.getRitualDummy().toString().substring(2).replace("occultism:ritual_dummy/", ""));
        this.dropResult(level, goldenBowlPosition, blockEntity, (Player)castingPlayer, flame, false);
    }
}

