/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.client.gui.satchel.SatchelScreen;
import com.klikli_dev.occultism.client.gui.storage.StorageControllerGui;
import com.klikli_dev.occultism.client.gui.storage.StorageRemoteGui;
import com.klikli_dev.occultism.handlers.ClientSetupEventHandler;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageDoubleJump;
import com.klikli_dev.occultism.network.messages.MessageOpenEnderSatchel;
import com.klikli_dev.occultism.network.messages.MessageOpenSatchel;
import com.klikli_dev.occultism.network.messages.MessageOpenStorageRemote;
import com.klikli_dev.occultism.network.messages.MessageToggleFamiliarSettings;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.klikli_dev.occultism.util.CuriosUtil;
import com.klikli_dev.occultism.util.MovementUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;

@EventBusSubscriber(modid="occultism", value={Dist.CLIENT})
public class ClientPlayerEventHandler {
    @SubscribeEvent
    public static void onPlaySoundAt(PlayLevelSoundEvent.AtPosition event) {
        if (event.getLevel().isClientSide && ((Boolean)Occultism.CLIENT_CONFIG.misc.disableSpiritFireSuccessSound.get()).booleanValue() && event.getSound() != null && event.getSound().value() == OccultismSounds.START_RITUAL.get() && event.getLevel().getBlockState(BlockPos.containing((Position)event.getPosition())).getBlock() == OccultismBlocks.SPIRIT_FIRE.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPlayerEventHandler.checkBackpackKey();
        ClientPlayerEventHandler.checkEnderBagKey();
        ClientPlayerEventHandler.checkStorageRemoteKey();
        ClientPlayerEventHandler.checkFamiliarSettingsKeys();
        if (event.getAction() == 1 && minecraft.options.keyJump.isDown() && minecraft.player != null && MovementUtil.doubleJump((Player)minecraft.player)) {
            Networking.sendToServer(new MessageDoubleJump());
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.Key event) {
        ClientPlayerEventHandler.checkBackpackKey();
        ClientPlayerEventHandler.checkEnderBagKey();
        ClientPlayerEventHandler.checkStorageRemoteKey();
        ClientPlayerEventHandler.checkFamiliarSettingsKeys();
    }

    public static void checkBackpackKey() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null & minecraft.screen == null && ClientSetupEventHandler.KEY_BACKPACK.consumeClick() && (!CuriosUtil.getBackpack((Player)minecraft.player).isEmpty() || CuriosUtil.getFirstBackpackSlot((Player)minecraft.player) > 0)) {
            Networking.sendToServer(new MessageOpenSatchel());
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value()), (float)0.75f, (float)1.0f));
        }
    }

    public static void checkEnderBagKey() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null & minecraft.screen == null && ClientSetupEventHandler.KEY_ENDER_BAG.consumeClick() && (!CuriosUtil.getEnderSatchel((Player)minecraft.player).isEmpty() || CuriosUtil.getFirstEnderSatchelSlot((Player)minecraft.player) > 0)) {
            Networking.sendToServer(new MessageOpenEnderSatchel());
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ENDER_CHEST_OPEN, (float)0.75f, (float)1.0f));
        }
    }

    public static void checkStorageRemoteKey() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null & minecraft.screen == null && ClientSetupEventHandler.KEY_STORAGE_REMOTE.consumeClick() && (!CuriosUtil.getStorageRemoteCurio((Player)minecraft.player).isEmpty() || CuriosUtil.getFirstStorageRemoteSlot((Player)minecraft.player) > 0)) {
            Networking.sendToServer(new MessageOpenStorageRemote());
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.ARMOR_EQUIP_DIAMOND.value()), (float)0.75f, (float)1.0f));
        }
    }

    public static void checkFamiliarSettingsKeys() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null & minecraft.screen == null) {
            boolean familiarKeyPressed = false;
            HashMap familiarsPressed = new HashMap();
            for (Map.Entry<EntityType<?>, KeyMapping> entry : ClientSetupEventHandler.keysFamiliars.entrySet()) {
                boolean isPressed = entry.getValue().consumeClick();
                if (isPressed) {
                    familiarKeyPressed = true;
                }
                familiarsPressed.put(entry.getKey(), isPressed);
            }
            if (familiarKeyPressed) {
                Networking.sendToServer(new MessageToggleFamiliarSettings(familiarsPressed));
            }
        }
    }

    @SubscribeEvent
    public static void onScreenKey(ScreenEvent.KeyPressed.Post event) {
        AbstractContainerScreen containerScreen;
        Screen screen = event.getScreen();
        if (screen instanceof ChatScreen) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        if (event.getKeyCode() == ClientSetupEventHandler.KEY_ENDER_BAG.getKey().getValue() && screen instanceof AbstractContainerScreen && (containerScreen = (AbstractContainerScreen)screen).getMenu() instanceof ChestMenu && screen.getTitle().getString().contains(Component.translatable((String)"block.minecraft.ender_chest").getString())) {
            minecraft.player.closeContainer();
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ENDER_CHEST_CLOSE, (float)0.75f, (float)1.0f));
            event.setCanceled(true);
        }
        if (event.getKeyCode() == ClientSetupEventHandler.KEY_BACKPACK.getKey().getValue() && minecraft.screen instanceof SatchelScreen) {
            minecraft.player.closeContainer();
            event.setCanceled(true);
        }
        if (event.getKeyCode() == ClientSetupEventHandler.KEY_STORAGE_REMOTE.getKey().getValue() && (minecraft.screen instanceof StorageRemoteGui || minecraft.screen instanceof StorageControllerGui)) {
            minecraft.player.closeContainer();
            event.setCanceled(true);
        }
    }
}

