/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.client;

import com.omnitools.omniTools.core.ModItems;
import com.omnitools.omniTools.core.OmniVajraItem;
import com.omnitools.omniTools.network.SyncVajraMiningSpeedPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="omnitools", value={Dist.CLIENT})
public class VajraClientEvents {
    private static final float SPEED_STEP = 10.0f;

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        if (event.getScrollDeltaY() == 0.0) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.screen != null) {
            return;
        }
        if (!player.isShiftKeyDown()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() != ModItems.OMNI_VAJRA.get()) {
            return;
        }
        float oldSpeed = OmniVajraItem.getMiningSpeed(stack);
        float delta = event.getScrollDeltaY() > 0.0 ? 10.0f : -10.0f;
        float newSpeed = oldSpeed + delta;
        OmniVajraItem.setMiningSpeed(stack, newSpeed);
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncVajraMiningSpeedPacket(OmniVajraItem.getMiningSpeed(stack)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.displayClientMessage((Component)Component.translatable((String)"message.omnitools.vajra_mining_speed", (Object[])new Object[]{Float.valueOf(OmniVajraItem.getMiningSpeed(stack))}), true);
        event.setCanceled(true);
    }
}

