/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.compat.ae2;

import appeng.api.ids.AEComponents;
import appeng.api.networking.IGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.SelectedPart;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.items.tools.MemoryCardItem;
import appeng.me.service.P2PService;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.InteractionUtil;
import appeng.util.SettingsFrom;
import com.omnitools.omniTools.api.IWrenchHandler;
import com.omnitools.omniTools.api.WrenchContext;
import com.omnitools.omniTools.core.ToolMode;
import com.omnitools.omniTools.mixin.ae2.P2PTunnelPartInvoker;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class Ae2MemoryCardWrenchHandler
implements IWrenchHandler {
    private static final Component PREFIX = Component.translatable((String)"omnitools.compat.ae2").append(" ");

    @Override
    public boolean canHandle(WrenchContext context) {
        if (context.getCurrentMode() != ToolMode.CONFIGURATION) {
            return false;
        }
        Level level = context.getLevel();
        if (level == null) {
            return false;
        }
        return this.resolveTarget(level, context.getPos(), context.getClickLocation()) != null;
    }

    @Override
    public InteractionResult handle(WrenchContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (level == null || player == null) {
            return InteractionResult.PASS;
        }
        Target target = this.resolveTarget(level, context.getPos(), context.getClickLocation());
        if (target == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getStack();
        boolean alt = InteractionUtil.isInAlternateUseMode((Player)player);
        if (target.kind == Kind.BLOCK) {
            return this.handleBlock(level, player, stack, alt, target.block);
        }
        return this.handlePart(level, player, stack, alt, target.part);
    }

    private InteractionResult handleBlock(Level level, Player player, ItemStack stack, boolean alt, AEBaseBlockEntity block) {
        if (alt) {
            DataComponentMap.Builder builder = DataComponentMap.builder();
            block.exportSettings(SettingsFrom.MEMORY_CARD, builder, player);
            DataComponentMap settings = builder.build();
            if (!settings.isEmpty()) {
                MemoryCardItem.clearCard((ItemStack)stack);
                stack.applyComponents(settings);
                player.displayClientMessage((Component)PREFIX.copy().append((Component)PlayerMessages.SavedSettings.text()), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        Component storedName = (Component)stack.get(AEComponents.EXPORTED_SETTINGS_SOURCE);
        MutableComponent blockName = block.getBlockState().getBlock().getName();
        if (storedName != null && blockName.equals((Object)storedName)) {
            block.importSettings(SettingsFrom.MEMORY_CARD, stack.getComponents(), player);
            player.displayClientMessage((Component)PREFIX.copy().append((Component)PlayerMessages.LoadedSettings.text()), true);
        } else {
            this.importGenericSettingsAndNotifyPrefixed(block, stack.getComponents(), player);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private InteractionResult handleP2P(Level level, Player player, ItemStack stack, boolean alt, P2PTunnelPart<?> tunnel) {
        IPartItem partItem;
        if (tunnel.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (alt) {
            short newFreq = tunnel.getFrequency();
            boolean wasOutput = tunnel.isOutput();
            ((P2PTunnelPartInvoker)tunnel).omnitools$invokeSetOutput(false);
            boolean needsNewFrequency = wasOutput || newFreq == 0;
            IGrid grid = tunnel.getMainNode().getGrid();
            if (grid != null) {
                P2PService p2p = P2PService.get((IGrid)grid);
                if (needsNewFrequency) {
                    newFreq = p2p.newFrequency();
                }
                p2p.updateFreq(tunnel, newFreq);
            }
            tunnel.onTunnelConfigChange();
            MemoryCardItem.clearCard((ItemStack)stack);
            stack.set(AEComponents.EXPORTED_SETTINGS_SOURCE, (Object)tunnel.getPartItem().asItem().getDescription());
            stack.applyComponents(tunnel.exportSettings(SettingsFrom.MEMORY_CARD));
            if (needsNewFrequency) {
                player.displayClientMessage((Component)PREFIX.copy().append((Component)PlayerMessages.ResetSettings.text()), true);
            } else {
                player.displayClientMessage((Component)PREFIX.copy().append((Component)PlayerMessages.SavedSettings.text()), true);
            }
            return InteractionResult.SUCCESS;
        }
        Item p2pTunnelItem = (Item)stack.get(AEComponents.EXPORTED_P2P_TYPE);
        if (p2pTunnelItem instanceof IPartItem && P2PTunnelPart.class.isAssignableFrom((partItem = (IPartItem)p2pTunnelItem).getPartClass())) {
            IPart newBus = tunnel;
            if (newBus.getPartItem() != partItem) {
                newBus = tunnel.getHost().replacePart(partItem, tunnel.getSide(), player, InteractionHand.MAIN_HAND);
            }
            if (newBus instanceof P2PTunnelPart) {
                IPart newTunnel = newBus;
                newTunnel.importSettings(SettingsFrom.MEMORY_CARD, stack.getComponents(), player);
            }
            player.displayClientMessage((Component)PREFIX.copy().append((Component)PlayerMessages.LoadedSettings.text()), true);
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)PREFIX.copy().append((Component)PlayerMessages.InvalidMachine.text()), true);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handlePart(Level level, Player player, ItemStack stack, boolean alt, AEBasePart part) {
        MutableComponent name;
        Item partAsItem;
        if (part instanceof P2PTunnelPart) {
            P2PTunnelPart p2p = (P2PTunnelPart)part;
            return this.handleP2P(level, player, stack, alt, p2p);
        }
        if (!part.useStandardMemoryCard()) {
            return InteractionResult.PASS;
        }
        IPartItem partItem = part.getPartItem();
        Item item = partAsItem = partItem == null ? null : partItem.asItem();
        if (partAsItem == AEParts.INTERFACE.asItem()) {
            partAsItem = AEBlocks.INTERFACE.asItem();
        } else if (partAsItem == AEParts.PATTERN_PROVIDER.asItem()) {
            partAsItem = AEBlocks.PATTERN_PROVIDER.asItem();
        }
        Object object = name = partAsItem == null ? Component.literal((String)"part") : partAsItem.getDescription();
        if (alt) {
            DataComponentMap settings = part.exportSettings(SettingsFrom.MEMORY_CARD);
            if (!settings.isEmpty()) {
                MemoryCardItem.clearCard((ItemStack)stack);
                stack.applyComponents(settings);
                player.displayClientMessage((Component)PREFIX.copy().append((Component)PlayerMessages.SavedSettings.text()), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        Component storedName = (Component)stack.get(AEComponents.EXPORTED_SETTINGS_SOURCE);
        if (storedName != null && name.equals((Object)storedName)) {
            part.importSettings(SettingsFrom.MEMORY_CARD, stack.getComponents(), player);
            player.displayClientMessage((Component)PREFIX.copy().append((Component)PlayerMessages.LoadedSettings.text()), true);
        } else {
            this.importGenericSettingsAndNotifyPrefixed(part, stack.getComponents(), player);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private void importGenericSettingsAndNotifyPrefixed(Object importTo, DataComponentMap input, Player player) {
        Set imported = MemoryCardItem.importGenericSettings((Object)importTo, (DataComponentMap)input, (Player)player);
        if (player != null && !player.getCommandSenderWorld().isClientSide()) {
            if (imported.isEmpty()) {
                player.displayClientMessage((Component)PREFIX.copy().append((Component)PlayerMessages.InvalidMachine.text()), true);
            } else {
                Component restored = Tooltips.conjunction(imported.stream().map(type -> Component.translatable((String)MemoryCardItem.getSettingTranslationKey((DataComponentType)type))).distinct().collect(Collectors.toList()));
                player.displayClientMessage((Component)PREFIX.copy().append((Component)PlayerMessages.InvalidMachinePartiallyRestored.text(new Object[]{restored})), true);
            }
        }
    }

    private Target resolveTarget(Level level, BlockPos pos, Vec3 click) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof IPartHost) {
            IPart iPart;
            IPartHost host = (IPartHost)be;
            SelectedPart sp = host.selectPartWorld(click);
            if (sp != null && (iPart = sp.part) instanceof AEBasePart) {
                AEBasePart aePart = (AEBasePart)iPart;
                return new Target(Kind.PART, null, aePart, aePart.getPartItem().asItem().getDescription());
            }
            return null;
        }
        if (be instanceof AEBaseBlockEntity) {
            AEBaseBlockEntity ae = (AEBaseBlockEntity)be;
            Component name = ae.getName();
            return new Target(Kind.BLOCK, ae, null, name);
        }
        return null;
    }

    private record Target(Kind kind, AEBaseBlockEntity block, AEBasePart part, Component name) {
    }

    private static enum Kind {
        BLOCK,
        PART;

    }
}

