/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.compat.draconicevolution;

import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.init.ItemData;
import com.omnitools.omniTools.api.IWrenchHandler;
import com.omnitools.omniTools.api.WrenchContext;
import com.omnitools.omniTools.core.ToolMode;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DraconicLinkWrenchHandler
implements IWrenchHandler {
    @Override
    public boolean canHandle(WrenchContext context) {
        if (context.getCurrentMode() != ToolMode.LINK) {
            return false;
        }
        Level level = context.getLevel();
        if (level == null) {
            return false;
        }
        BlockEntity be = level.getBlockEntity(context.getPos());
        if (be instanceof ICrystalLink) {
            return true;
        }
        return this.isBound(context.getStack());
    }

    @Override
    public InteractionResult handle(WrenchContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.getStack();
        BlockPos pos = context.getPos();
        Direction face = context.getFace();
        BlockEntity tile = level.getBlockEntity(pos);
        boolean isLinkable = tile instanceof ICrystalLink;
        boolean isBound = this.isBound(stack);
        if (isLinkable && player.isShiftKeyDown() && !isBound) {
            this.bind(stack, pos, (ResourceKey<Level>)((ServerLevel)level).dimension());
            ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"omnitools.compat.draconicevolution").append(" ").append((Component)Component.translatable((String)"gui.draconicevolution.energy_net.pos_saved_to_tool")), (UUID)TileCrystalBase.MSG_ID);
            return InteractionResult.SUCCESS;
        }
        if (isLinkable && !isBound) {
            ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"omnitools.compat.draconicevolution").append(" ").append((Component)Component.translatable((String)"gui.draconicevolution.energy_net.tool_not_bound")), (UUID)TileCrystalBase.MSG_ID);
            return InteractionResult.SUCCESS;
        }
        if (isBound) {
            BlockPos boundPos = this.getBound(stack);
            if (boundPos.equals((Object)pos)) {
                ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"omnitools.compat.draconicevolution").append(" ").append((Component)Component.translatable((String)"gui.draconicevolution.energy_net.link_to_self")), (UUID)TileCrystalBase.MSG_ID);
                return InteractionResult.SUCCESS;
            }
            BlockEntity boundTile = level.getBlockEntity(boundPos);
            if (boundTile instanceof ICrystalLink) {
                ICrystalLink link = (ICrystalLink)boundTile;
                link.binderUsed(player, pos, face);
            } else {
                ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"omnitools.compat.draconicevolution").append(" ").append((Component)Component.translatable((String)"gui.draconicevolution.energy_net.bound_to_invalid")), (UUID)TileCrystalBase.MSG_ID);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean isBound(ItemStack stack) {
        return stack.has((Supplier)ItemData.BINDER_POS);
    }

    private void bind(ItemStack stack, BlockPos pos, ResourceKey<Level> dim) {
        stack.set((Supplier)ItemData.BINDER_POS, (Object)GlobalPos.of(dim, (BlockPos)pos));
    }

    private BlockPos getBound(ItemStack stack) {
        GlobalPos gp = (GlobalPos)stack.get((Supplier)ItemData.BINDER_POS);
        return gp == null ? BlockPos.ZERO : gp.pos();
    }
}

