/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.compat.entangled;

import com.omnitools.omniTools.api.IWrenchHandler;
import com.omnitools.omniTools.api.WrenchContext;
import com.omnitools.omniTools.core.ToolMode;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.entangled.EntangledBinderItem;
import com.supermartijn642.entangled.EntangledBlock;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledConfig;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EntangledBinderWrenchHandler
implements IWrenchHandler {
    @Override
    public boolean canHandle(WrenchContext context) {
        return context.getCurrentMode() == ToolMode.LINK;
    }

    @Override
    public InteractionResult handle(WrenchContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (level == null || player == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getPos();
        ItemStack stack = context.getStack();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof EntangledBlock) {
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity entity = level.getBlockEntity(pos);
            if (!(entity instanceof EntangledBlockEntity)) {
                return InteractionResult.PASS;
            }
            EntangledBlockEntity entangled = (EntangledBlockEntity)entity;
            if (EntangledBinderItem.isBound((ItemStack)stack)) {
                ResourceLocation targetDimension = EntangledBinderItem.getBoundDimension((ItemStack)stack);
                BlockPos targetPos = EntangledBinderItem.getBoundPosition((ItemStack)stack);
                if (EntangledBlock.canBindTo((ResourceLocation)level.dimension().location(), (BlockPos)pos, (ResourceLocation)targetDimension, (BlockPos)targetPos)) {
                    entangled.bind(targetPos, targetDimension);
                    player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.entangled").append(" ").append((Component)TextComponents.translation((String)"entangled.entangled_block.bind").color(ChatFormatting.YELLOW).get()), true);
                } else if (CommonUtils.getLevel((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)targetDimension)) == null) {
                    player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.entangled").append(" ").append((Component)TextComponents.translation((String)"entangled.entangled_binder.unknown_dimension", (Object[])new Object[]{targetDimension}).color(ChatFormatting.RED).get()), true);
                } else if (!level.dimension().location().equals((Object)targetDimension) && !((Boolean)EntangledConfig.allowDimensional.get()).booleanValue()) {
                    player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.entangled").append(" ").append((Component)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(ChatFormatting.RED).get()), true);
                } else if (pos.equals((Object)targetPos)) {
                    player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.entangled").append(" ").append((Component)TextComponents.translation((String)"entangled.entangled_block.self").color(ChatFormatting.RED).get()), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.entangled").append(" ").append((Component)TextComponents.translation((String)"entangled.entangled_block.too_far").color(ChatFormatting.RED).get()), true);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.entangled").append(" ").append((Component)TextComponents.translation((String)"entangled.entangled_block.no_selection").color(ChatFormatting.RED).get()), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        EntangledBinderItem.BinderTarget target = (EntangledBinderItem.BinderTarget)stack.get(EntangledBinderItem.BINDER_TARGET);
        ResourceLocation currentDimension = level.dimension().location();
        if (target != null && target.dimension().equals((Object)currentDimension) && target.pos().equals((Object)pos)) {
            return InteractionResult.SUCCESS;
        }
        BlockState targetState = level.getBlockState(pos);
        Optional<BlockState> optionalState = Optional.of(targetState);
        stack.set(EntangledBinderItem.BINDER_TARGET, (Object)new EntangledBinderItem.BinderTarget(currentDimension, pos, optionalState));
        player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.entangled").append(" ").append((Component)TextComponents.translation((String)"entangled.entangled_binder.select").color(ChatFormatting.YELLOW).get()), true);
        return InteractionResult.SUCCESS;
    }
}

