/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.compat.mebeamformer;

import com.mebeamformer.item.LaserBindingTool;
import com.omnitools.omniTools.api.IWrenchHandler;
import com.omnitools.omniTools.api.WrenchContext;
import com.omnitools.omniTools.core.ToolMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class MEBeamFormerWrenchHandler
implements IWrenchHandler {
    private static LaserBindingTool CACHED_TOOL = null;

    private static LaserBindingTool getLaserBindingTool() {
        if (CACHED_TOOL != null) {
            return CACHED_TOOL;
        }
        for (Item item : BuiltInRegistries.ITEM) {
            LaserBindingTool tool;
            if (!(item instanceof LaserBindingTool)) continue;
            CACHED_TOOL = tool = (LaserBindingTool)item;
            return tool;
        }
        return null;
    }

    @Override
    public boolean canHandle(WrenchContext context) {
        return context.getCurrentMode() == ToolMode.LINK;
    }

    @Override
    public InteractionResult handle(WrenchContext context) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getStack();
        BlockPos pos = context.getPos();
        Direction face = context.getFace();
        InteractionHand hand = player.getMainHandItem() == stack ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        BlockHitResult hit = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), face, pos, false);
        UseOnContext useOnContext = new UseOnContext(player, hand, hit);
        LaserBindingTool tool = MEBeamFormerWrenchHandler.getLaserBindingTool();
        if (tool == null) {
            return InteractionResult.PASS;
        }
        return tool.useOn(useOnContext);
    }
}

