/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.compat.mekanism;

import com.omnitools.omniTools.api.IWrenchHandler;
import com.omnitools.omniTools.api.WrenchContext;
import com.omnitools.omniTools.core.ToolMode;
import java.util.function.Supplier;
import mekanism.api.IConfigCardAccess;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.ConfigurationCardTrigger;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class MekanismConfigCardWrenchHandler
implements IWrenchHandler {
    @Nullable
    private static IConfigCardAccess getConfigCardAccess(Level level, BlockPos pos, Direction face) {
        IConfigCardAccess configCardAccess = (IConfigCardAccess)WorldUtils.getCapability((Level)level, (BlockCapability)Capabilities.CONFIG_CARD, (BlockPos)pos, (Object)face);
        if (configCardAccess != null) {
            return configCardAccess;
        }
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)level, (BlockPos)pos);
        if (tile == null) {
            return null;
        }
        return (IConfigCardAccess)WorldUtils.getCapability((Level)level, (BlockCapability)Capabilities.CONFIG_CARD, (BlockPos)pos, null, (BlockEntity)tile, null);
    }

    @Override
    public boolean canHandle(WrenchContext context) {
        Direction face;
        if (context.getCurrentMode() != ToolMode.CONFIGURATION) {
            return false;
        }
        Level level = context.getLevel();
        if (level == null) {
            return false;
        }
        BlockPos pos = context.getPos();
        IConfigCardAccess configCardAccess = MekanismConfigCardWrenchHandler.getConfigCardAccess(level, pos, face = context.getFace());
        return configCardAccess != null;
    }

    @Override
    public InteractionResult handle(WrenchContext context) {
        Direction face;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (level == null || player == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getPos();
        IConfigCardAccess configCardAccess = MekanismConfigCardWrenchHandler.getConfigCardAccess(level, pos, face = context.getFace());
        if (configCardAccess == null) {
            return InteractionResult.PASS;
        }
        if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, level, pos)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getStack();
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                String translationKey = configCardAccess.getConfigCardName();
                CompoundTag data = configCardAccess.getConfigurationData((HolderLookup.Provider)level.registryAccess(), player);
                data.putString("data_name", translationKey);
                NBTUtils.writeRegistryEntry((CompoundTag)data, (String)"data_type", (Registry)BuiltInRegistries.BLOCK, (Object)configCardAccess.getConfigurationDataType());
                stack.set((Supplier)MekanismDataComponents.CONFIGURATION_DATA, (Object)data);
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.mekanism").append(" ").append((Component)MekanismLang.CONFIG_CARD_GOT.translate(new Object[]{EnumColor.INDIGO, TextComponentUtil.translate((String)translationKey)})), true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((ConfigurationCardTrigger)MekanismCriteriaTriggers.CONFIGURATION_CARD.value()).trigger(serverPlayer, true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        CompoundTag data = MekanismConfigCardWrenchHandler.getData(stack);
        Block storedType = MekanismConfigCardWrenchHandler.getStoredType(data);
        if (storedType == null) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!level.isClientSide) {
            if (configCardAccess.isConfigurationDataCompatible(storedType)) {
                configCardAccess.setConfigurationData((HolderLookup.Provider)level.registryAccess(), player, data);
                configCardAccess.configurationDataSet();
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.mekanism").append(" ").append((Component)MekanismLang.CONFIG_CARD_SET.translate(new Object[]{EnumColor.INDIGO, MekanismConfigCardWrenchHandler.getConfigCardName(data)})), true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((ConfigurationCardTrigger)MekanismCriteriaTriggers.CONFIGURATION_CARD.value()).trigger(serverPlayer, false);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.mekanism").append(" ").append((Component)MekanismLang.CONFIG_CARD_UNEQUAL.translateColored(EnumColor.RED)), true);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    private static CompoundTag getData(ItemStack stack) {
        CompoundTag data = (CompoundTag)stack.get((Supplier)MekanismDataComponents.CONFIGURATION_DATA);
        if (data == null || data.isEmpty()) {
            return null;
        }
        return data;
    }

    @Nullable
    private static Block getStoredType(@Nullable CompoundTag data) {
        if (data == null || !data.contains("data_type", 8)) {
            return null;
        }
        ResourceLocation blockRegistryName = ResourceLocation.tryParse((String)data.getString("data_type"));
        return blockRegistryName == null ? null : (Block)BuiltInRegistries.BLOCK.get(blockRegistryName);
    }

    private static Component getConfigCardName(@Nullable CompoundTag data) {
        if (data == null || !data.contains("data_name", 8)) {
            return MekanismLang.NONE.translate();
        }
        return TextComponentUtil.translate((String)data.getString("data_name"));
    }
}

