/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.core;

import com.omnitools.omniTools.api.UseContext;
import com.omnitools.omniTools.api.WrenchContext;
import com.omnitools.omniTools.core.ToolMode;
import com.omnitools.omniTools.core.UseHandlerRegistry;
import com.omnitools.omniTools.core.WrenchHandlerRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;

public class OmniToolItem
extends Item {
    private static final String MODE_TAG = "ToolMode";

    public OmniToolItem(Item.Properties properties) {
        super(properties);
    }

    public static ToolMode getMode(ItemStack stack) {
        CompoundTag tag;
        if (stack.isEmpty()) {
            return ToolMode.WRENCH;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && (tag = customData.copyTag()).contains(MODE_TAG)) {
            ToolMode mode = ToolMode.fromId(tag.getString(MODE_TAG));
            if (mode == ToolMode.RENAME && !OmniToolItem.isRenameModeEnabled()) {
                return ToolMode.WRENCH;
            }
            return mode;
        }
        return ToolMode.WRENCH;
    }

    public static void setMode(ItemStack stack, ToolMode mode) {
        if (stack.isEmpty()) {
            return;
        }
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        tag.putString(MODE_TAG, mode.getId());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static void cycleMode(ItemStack stack) {
        ToolMode current = OmniToolItem.getMode(stack);
        ToolMode[] modes = ToolMode.values();
        ToolMode next = current;
        for (int i = 1; i <= modes.length; ++i) {
            ToolMode candidate = modes[(current.ordinal() + i) % modes.length];
            if (candidate == ToolMode.RENAME && !OmniToolItem.isRenameModeEnabled()) continue;
            next = candidate;
            break;
        }
        OmniToolItem.setMode(stack, next);
    }

    private static boolean isRenameModeEnabled() {
        return ModList.get() != null && ModList.get().isLoaded("ae2");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.omnitools.omni_wrench.main").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.omnitools.omni_wrench.controls").withStyle(ChatFormatting.DARK_GRAY));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        UseContext useContext;
        InteractionResultHolder<ItemStack> result;
        ItemStack stack;
        ItemStack itemStack = stack = player != null ? player.getItemInHand(hand) : ItemStack.EMPTY;
        if (player != null && (result = UseHandlerRegistry.handle(useContext = new UseContext(level, player, hand, stack))).getResult().consumesAction()) {
            return result;
        }
        return super.use(level, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        WrenchContext wrenchContext;
        InteractionResult result;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        if (player != null && (result = WrenchHandlerRegistry.handle(wrenchContext = new WrenchContext(level, pos, face, context.getClickLocation(), player, context.getItemInHand()))).consumesAction()) {
            return result;
        }
        return super.useOn(context);
    }
}

