/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.blocks.interaction.DronePortBlock;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.DroneScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.item.tools.LaserTargetDesignator;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DronePortEntity
extends NetworkedBlockEntity
implements ItemApi.BlockProvider,
FluidApi.BlockProvider,
EnergyApi.BlockProvider,
GeoBlockEntity,
MultiblockMachineController,
MachineAddonController,
ExtendedMenuProvider,
ScreenProvider,
RedstoneAddonBlockEntity.RedstoneControllable {
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<BlockPos> connectedAddons = new ArrayList<BlockPos>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<BlockPos> openSlots = new ArrayList<BlockPos>();
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(32768L, 10000L, 0L, this::setChanged);
    public final DronePortItemInventory inventory = new DronePortItemInventory(15, this::setChanged);
    @SyncField(value={SyncType.GUI_TICK})
    public final DronePortFluidStorage fluidStorage = new DronePortFluidStorage(128L * FluidStackHooks.bucketAmount(), this::setChanged);
    protected final SimpleContainer cardInventory = new SimpleContainer(2){

        public void setChanged() {
            DronePortEntity.this.setChanged();
        }

        public boolean canAddItem(ItemStack stack) {
            return stack.getItem() instanceof LaserTargetDesignator;
        }
    };
    @SyncField(value={SyncType.GUI_OPEN})
    private float coreQuality = 1.0f;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ArrayList<BlockPos> coreBlocksConnected = new ArrayList();
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasFluidAddon;
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean disabledViaRedstone;
    private BlockPos targetPosition;
    private long lastSentAt;
    private DroneTransferData incomingPacket;
    private boolean receivingPackage;
    private final long baseEnergyUsage = 1024L;
    private final int takeOffTime = 300;
    private final int landTime = 260;
    private final int totalFlightTime = 560;
    @SyncField(value={SyncType.GUI_TICK})
    private String statusMessage = "";
    public static final RawAnimation TAKEOFF = RawAnimation.begin().thenPlay("takeoff");
    public static final RawAnimation LANDING = RawAnimation.begin().thenPlay("landing");

    public DronePortEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.DRONE_PORT_ENTITY, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        this.checkPositionCard();
        if (this.incomingPacket != null) {
            this.checkIncomingAnimation();
        }
        if (world.getGameTime() % 20L == 0L) {
            if (this.incomingPacket != null) {
                this.tryReceivePacket();
            } else if (this.canSend()) {
                this.sendDrone();
            }
        }
    }

    private void checkPositionCard() {
        ItemStack source = (ItemStack)this.cardInventory.getItems().get(0);
        if (!(source.getItem() instanceof LaserTargetDesignator) || !source.has((DataComponentType)ComponentContent.TARGET_POSITION.get())) {
            return;
        }
        BlockPos target = (BlockPos)source.get((DataComponentType)ComponentContent.TARGET_POSITION.get());
        this.setTargetFromDesignator(target);
        this.cardInventory.getItems().set(1, (Object)source);
        this.cardInventory.getItems().set(0, (Object)ItemStack.EMPTY);
        this.cardInventory.setChanged();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory.getHeldStacks(), (boolean)false, (HolderLookup.Provider)registryLookup);
        this.addMultiblockToNbt(nbt);
        this.writeAddonToNbt(nbt);
        this.fluidStorage.writeNbt(nbt, "");
        nbt.putBoolean("has_fluid_addon", this.hasFluidAddon);
        nbt.putBoolean("disabled_via_redstone", this.disabledViaRedstone);
        nbt.putLong("energy_stored", this.energyStorage.amount);
        if (this.targetPosition != null) {
            nbt.putLong("target_position", this.targetPosition.asLong());
        }
        CompoundTag cardCompound = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)cardCompound, (NonNullList)this.cardInventory.getItems(), (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.put("cards", (Tag)cardCompound);
        if (this.incomingPacket != null) {
            CompoundTag compound = new CompoundTag();
            NonNullList list = NonNullList.createWithCapacity((int)this.incomingPacket.transferredStacks.size());
            list.addAll(this.incomingPacket.transferredStacks);
            ContainerHelper.saveAllItems((CompoundTag)compound, (NonNullList)list, (boolean)false, (HolderLookup.Provider)registryLookup);
            nbt.put("incoming", (Tag)compound);
            FluidStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.incomingPacket.movedFluid).result().ifPresent(tag -> nbt.put("fluidmoving", tag));
            nbt.putLong("incomingTime", this.incomingPacket.arrivesAt);
        } else {
            nbt.remove("incoming");
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory.getHeldStacks(), (HolderLookup.Provider)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.loadAddonNbtData(nbt);
        this.fluidStorage.readNbt(nbt, "");
        this.hasFluidAddon = nbt.getBoolean("has_fluid_addon");
        this.disabledViaRedstone = nbt.getBoolean("disabled_via_redstone");
        this.energyStorage.amount = nbt.getLong("energy_stored");
        this.targetPosition = BlockPos.of((long)nbt.getLong("target_position"));
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("cards"), (NonNullList)this.cardInventory.getItems(), (HolderLookup.Provider)registryLookup);
        if (nbt.contains("incoming")) {
            NonNullList list = NonNullList.withSize((int)15, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("incoming"), (NonNullList)list, (HolderLookup.Provider)registryLookup);
            FluidStack fluid = FluidStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("fluidmoving")).result().orElse(FluidStack.empty());
            long arrivalTime = nbt.getLong("incomingTime");
            this.incomingPacket = new DroneTransferData((List<ItemStack>)list, fluid, arrivalTime);
        }
    }

    @Override
    public void initAddons() {
        MachineAddonController.super.initAddons();
        this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
        for (Vec3i corePosition : this.getCorePositions()) {
            BlockPos worldPos = new BlockPos(Geometry.offsetToWorldPosition(this.getFacingForMultiblock(), corePosition, (Vec3i)this.getPosForAddon()));
            this.level.blockUpdated(worldPos, this.level.getBlockState(worldPos).getBlock());
        }
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        CombiAddonEntity combi;
        AddonBlockEntity addonBlockEntity;
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_FLUID_ADDON) || (addonBlockEntity = addonBlock.addonEntity()) instanceof CombiAddonEntity && (combi = (CombiAddonEntity)addonBlockEntity).hasFluid()) {
            this.hasFluidAddon = true;
        }
    }

    @Override
    public void resetAddons() {
        MachineAddonController.super.resetAddons();
        this.hasFluidAddon = false;
    }

    private void checkIncomingAnimation() {
        if (this.level.getGameTime() == this.incomingPacket.arrivesAt - 260L) {
            this.triggerNetworkReceiveAnimation();
        }
    }

    private void tryReceivePacket() {
        boolean hasArrived;
        boolean bl = hasArrived = this.level.getGameTime() - this.incomingPacket.arrivesAt > 0L;
        if (!hasArrived) {
            return;
        }
        Oritech.LOGGER.debug("receiving drone package: " + String.valueOf(this.incomingPacket));
        this.receivingPackage = true;
        long totalToInsert = this.incomingPacket.transferredStacks.stream().mapToLong(ItemStack::getCount).sum();
        long totalInserted = 0L;
        for (ItemStack stack : this.incomingPacket.transferredStacks) {
            totalInserted += (long)this.inventory.insert(stack, false);
        }
        if (totalInserted != totalToInsert) {
            Oritech.LOGGER.warn("Something weird has happened with drone port item storage. Caused at: " + String.valueOf(this.worldPosition));
            return;
        }
        if (!this.incomingPacket.movedFluid.isEmpty()) {
            this.fluidStorage.insertFromDrone(this.incomingPacket.movedFluid, false);
        }
        this.receivingPackage = false;
        this.incomingPacket = null;
        this.setChanged();
    }

    private void sendDrone() {
        DronePortEntity targetPort = (DronePortEntity)this.level.getBlockEntity(this.targetPosition);
        long arriveTime = this.level.getGameTime() + 300L + 260L;
        DroneTransferData data = new DroneTransferData(this.inventory.getHeldStacks().stream().filter(stack -> !stack.isEmpty()).toList(), this.fluidStorage.getStack(), arriveTime);
        targetPort.setIncomingPacket(data);
        this.inventory.clearContent();
        this.fluidStorage.setStack(FluidStack.empty());
        this.lastSentAt = this.level.getGameTime();
        this.energyStorage.amount -= this.calculateEnergyUsage();
        this.triggerNetworkSendAnimation();
        targetPort.setChanged();
        this.setChanged();
        Oritech.LOGGER.debug("sending drone package: " + String.valueOf(data));
    }

    public boolean canAcceptPayload(List<ItemStack> stacks, FluidStack fluid) {
        if (!stacks.isEmpty() && !this.inventory.isEmpty()) {
            return false;
        }
        return fluid.isEmpty() || this.hasFluidAddon && this.fluidStorage.insert(fluid, true) == fluid.getAmount();
    }

    public boolean isSendingDrone() {
        long diff = this.level.getGameTime() - this.lastSentAt;
        return diff < 300L;
    }

    private boolean canSend() {
        block5: {
            block4: {
                if (this.disabledViaRedstone || this.targetPosition == null || this.inventory.isEmpty() && this.fluidStorage.getAmount() == 0L || this.energyStorage.amount < this.calculateEnergyUsage() || this.incomingPacket != null) {
                    return false;
                }
                BlockEntity targetEntity = this.level.getBlockEntity(this.targetPosition);
                if (!(targetEntity instanceof DronePortEntity)) break block4;
                DronePortEntity targetPort = (DronePortEntity)targetEntity;
                if (!targetPort.disabledViaRedstone && targetPort.getIncomingPacket() == null && targetPort.canAcceptPayload((List<ItemStack>)this.inventory.getHeldStacks(), this.fluidStorage.getStack())) break block5;
            }
            return false;
        }
        return !this.isSendingDrone();
    }

    private long calculateEnergyUsage() {
        if (this.targetPosition == null) {
            return 1024L;
        }
        int distance = this.worldPosition.distManhattan((Vec3i)this.targetPosition);
        return (long)Math.sqrt(distance) * 50L + 1024L;
    }

    private void triggerNetworkSendAnimation() {
        this.triggerAnim("machine", "takeoff");
    }

    private void triggerNetworkReceiveAnimation() {
        this.triggerAnim("machine", "landing");
    }

    public boolean setTargetFromDesignator(BlockPos targetPos) {
        int distance;
        MachineCoreEntity coreEntity;
        BlockPos controllerPos;
        BlockState targetState = Objects.requireNonNull(this.level).getBlockState(targetPos);
        if (targetState.getBlock() instanceof MachineCoreBlock && ((Boolean)targetState.getValue((Property)MachineCoreBlock.USED)).booleanValue() && (controllerPos = Objects.requireNonNull(coreEntity = (MachineCoreEntity)this.level.getBlockEntity(targetPos)).getControllerPos()) != null) {
            targetPos = controllerPos;
        }
        if ((distance = targetPos.distManhattan((Vec3i)this.worldPosition)) < 50) {
            this.statusMessage = "message.oritech.drone.invalid_distance";
            return false;
        }
        if (this.level.getBlockState(targetPos).getBlock() instanceof DronePortBlock) {
            this.targetPosition = targetPos;
            this.statusMessage = "message.oritech.drone.target_set";
            return true;
        }
        this.statusMessage = "message.oritech.drone.target_invalid";
        return false;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, -1), new Vec3i(-2, 0, 1), new Vec3i(-2, 0, 0), new Vec3i(-2, 0, -1), new Vec3i(0, 1, 0), new Vec3i(0, 1, 1), new Vec3i(-1, 1, -1));
    }

    @Override
    public Direction getFacingForMultiblock() {
        return ((Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
    }

    @Override
    public BlockPos getPosForAddon() {
        return this.worldPosition;
    }

    @Override
    public Level getWorldForAddon() {
        return this.level;
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(Direction direction) {
        return this.energyStorage;
    }

    @Override
    @Nullable
    public FluidApi.FluidStorage getFluidStorage(Direction direction) {
        return this.hasFluidAddon ? this.fluidStorage : null;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(3, 0, -1), new Vec3i(2, 0, -2));
    }

    @Override
    public long getDefaultCapacity() {
        return 32768L;
    }

    @Override
    public long getDefaultInsertRate() {
        return 512L;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    public DynamicEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public List<BlockPos> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<BlockPos> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public Direction getFacingForAddon() {
        return (Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.getEnergyStorage();
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
        this.setChanged();
    }

    public DroneTransferData getIncomingPacket() {
        return this.incomingPacket;
    }

    public void setIncomingPacket(DroneTransferData incomingPacket) {
        this.incomingPacket = incomingPacket;
    }

    public boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
    }

    @Override
    public void triggerSetupAnimation() {
        this.triggerAnim("machine", "deploy");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 0, state -> {
            if (state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                RawAnimation targetAnim = this.isActive(this.getBlockState()) ? MachineBlockEntity.IDLE : MachineBlockEntity.PACKAGED;
                state.resetCurrentAnimation();
                return state.setAndContinue(targetAnim);
            }
            return PlayState.CONTINUE;
        }).triggerableAnim("takeoff", TAKEOFF).triggerableAnim("landing", LANDING).triggerableAnim("deploy", MachineBlockEntity.SETUP).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.getHeldStacks().size() <= slot) {
            return this.hasFluidAddon ? ComparatorOutputProvider.getFluidStorageComparatorOutput(this.fluidStorage) : 0;
        }
        ItemStack stack = this.inventory.getItem(slot);
        if (stack.isEmpty()) {
            return this.hasFluidAddon ? ComparatorOutputProvider.getFluidStorageComparatorOutput(this.fluidStorage) : 0;
        }
        return this.hasFluidAddon ? Math.max(ComparatorOutputProvider.getItemStackComparatorOutput(stack), ComparatorOutputProvider.getFluidStorageComparatorOutput(this.fluidStorage)) : ComparatorOutputProvider.getItemStackComparatorOutput(stack);
    }

    @Override
    public int getComparatorProgress() {
        if (this.isSendingDrone()) {
            return (int)((float)(this.level.getGameTime() - this.lastSentAt) / 300.0f * 15.0f);
        }
        if (this.incomingPacket != null) {
            return (int)((float)(560L + (this.level.getGameTime() - this.incomingPacket.arrivesAt)) / 560.0f * 15.0f);
        }
        return 0;
    }

    @Override
    public int getComparatorActiveState() {
        return this.isSendingDrone() || this.incomingPacket != null ? 15 : 0;
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.disabledViaRedstone = isPowered;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.disabledViaRedstone) {
            return 15;
        }
        return 0;
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.disabledViaRedstone) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled";
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new DroneScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        int startX = 30;
        int startY = 26;
        int distance = 18;
        ArrayList<ScreenProvider.GuiSlot> list = new ArrayList<ScreenProvider.GuiSlot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 5; ++x) {
                int index = y * 5 + x;
                list.add(new ScreenProvider.GuiSlot(index, startX + x * distance, startY + y * distance));
            }
        }
        return list;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.calculateEnergyUsage();
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.DRONE_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    public SimpleContainer getCardInventory() {
        return this.cardInventory;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public BlockPos getPosForMultiblock() {
        return this.worldPosition;
    }

    @Override
    public Level getWorldForMultiblock() {
        return this.level;
    }

    public class DronePortItemInventory
    extends SimpleInventoryStorage {
        public DronePortItemInventory(int size, Runnable onUpdate) {
            super(size, onUpdate);
        }

        @Override
        public int insertToSlot(ItemStack addedStack, int slot, boolean simulate) {
            if (DronePortEntity.this.incomingPacket != null && !DronePortEntity.this.receivingPackage) {
                return 0;
            }
            return super.insertToSlot(addedStack, slot, simulate);
        }
    }

    public class DronePortFluidStorage
    extends SimpleFluidStorage {
        public DronePortFluidStorage(Long capacity, Runnable onUpdate) {
            super(capacity, onUpdate);
        }

        @Override
        public long insert(FluidStack toInsert, boolean simulate) {
            if (DronePortEntity.this.incomingPacket != null) {
                return 0L;
            }
            return super.insert(toInsert, simulate);
        }

        public long insertFromDrone(FluidStack toInsert, boolean simulate) {
            return super.insert(toInsert, simulate);
        }
    }

    public record DroneTransferData(List<ItemStack> transferredStacks, FluidStack movedFluid, long arrivesAt) {
    }
}

