/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.entity.client;

import com.lumengrid.oritechthings.entity.custom.AmethystFishEntity;
import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class AmethystFishModel<T extends AmethystFishEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart[] bodyParts = new ModelPart[7];
    private final ModelPart[] bodyLayers = new ModelPart[3];
    private static final int[][] BODY_SIZES = new int[][]{{3, 2, 2}, {4, 3, 2}, {6, 4, 3}, {3, 3, 3}, {2, 2, 3}, {2, 1, 2}, {1, 1, 2}};
    private static final int[][] BODY = new int[][]{{0, 0}, {0, 4}, {0, 9}, {0, 16}, {0, 22}, {11, 0}, {13, 4}};

    public AmethystFishModel(ModelPart root) {
        this.root = root;
        Arrays.setAll(this.bodyParts, p_170939_ -> root.getChild(AmethystFishModel.getSegmentName(p_170939_)));
        Arrays.setAll(this.bodyLayers, p_170933_ -> root.getChild(AmethystFishModel.getLayerName(p_170933_)));
    }

    private static String getLayerName(int index) {
        return "layer" + index;
    }

    private static String getSegmentName(int index) {
        return "segment" + index;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float[] afloat = new float[7];
        float f = -3.5f;
        for (int i = 0; i < 7; ++i) {
            partdefinition.addOrReplaceChild(AmethystFishModel.getSegmentName(i), CubeListBuilder.create().texOffs(BODY[i][0], BODY[i][1]).addBox((float)BODY_SIZES[i][0] * -0.5f, 0.0f, (float)BODY_SIZES[i][2] * -0.5f, (float)BODY_SIZES[i][0], (float)BODY_SIZES[i][1], (float)BODY_SIZES[i][2]), PartPose.offset((float)0.0f, (float)(24 - BODY_SIZES[i][1]), (float)f));
            afloat[i] = f;
            if (i >= 6) continue;
            f += (float)(BODY_SIZES[i][2] + BODY_SIZES[i + 1][2]) * 0.5f;
        }
        partdefinition.addOrReplaceChild(AmethystFishModel.getLayerName(0), CubeListBuilder.create().texOffs(20, 0).addBox(-5.0f, 0.0f, (float)BODY_SIZES[2][2] * -0.5f, 10.0f, 8.0f, (float)BODY_SIZES[2][2]), PartPose.offset((float)0.0f, (float)16.0f, (float)afloat[2]));
        partdefinition.addOrReplaceChild(AmethystFishModel.getLayerName(1), CubeListBuilder.create().texOffs(20, 11).addBox(-3.0f, 0.0f, (float)BODY_SIZES[4][2] * -0.5f, 6.0f, 4.0f, (float)BODY_SIZES[4][2]), PartPose.offset((float)0.0f, (float)20.0f, (float)afloat[4]));
        partdefinition.addOrReplaceChild(AmethystFishModel.getLayerName(2), CubeListBuilder.create().texOffs(20, 18).addBox(-3.0f, 0.0f, (float)BODY_SIZES[4][2] * -0.5f, 6.0f, 5.0f, (float)BODY_SIZES[1][2]), PartPose.offset((float)0.0f, (float)19.0f, (float)afloat[1]));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < this.bodyParts.length; ++i) {
            this.bodyParts[i].yRot = Mth.cos((float)(ageInTicks * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.05f * (float)(1 + Math.abs(i - 2));
            this.bodyParts[i].x = Mth.sin((float)(ageInTicks * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.2f * (float)Math.abs(i - 2);
        }
        this.bodyLayers[0].yRot = this.bodyParts[2].yRot;
        this.bodyLayers[1].yRot = this.bodyParts[4].yRot;
        this.bodyLayers[1].x = this.bodyParts[4].x;
        this.bodyLayers[2].yRot = this.bodyParts[1].yRot;
        this.bodyLayers[2].x = this.bodyParts[1].x;
    }
}

