/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.item.custom;

import com.lumengrid.oritechthings.client.screen.ScreenOpener;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.util.Geometry;

public class FramePlacer
extends Item {
    public FramePlacer(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand handIn) {
        if (!level.isClientSide()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(handIn));
        }
        HitResult hit = player.pick(5.0, 1.0f, false);
        BlockHitResult hitResult = (BlockHitResult)hit;
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = hitResult.getBlockPos();
            BlockEntity targetEntity = level.getBlockEntity(pos);
            if (targetEntity instanceof FrameInteractionBlockEntity) {
                FrameInteractionBlockEntity entity = (FrameInteractionBlockEntity)targetEntity;
                BlockState targetState = level.getBlockState(pos);
                if (((Boolean)targetState.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
                    Vec3i backRelative = new Vec3i(entity.getFrameOffset(), 0, 0);
                    Direction facing = (Direction)targetState.getValue((Property)HorizontalDirectionalBlock.FACING);
                    BlockPos searchStart = (BlockPos)Geometry.offsetToWorldPosition((Direction)facing, (Vec3i)backRelative, (Vec3i)pos);
                    ScreenOpener.openFramePlacer(searchStart, facing.getOpposite());
                    return InteractionResultHolder.success((Object)player.getItemInHand(handIn));
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.oritechthings.frame_placer.not_assembled").withStyle(ChatFormatting.RED), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.oritechthings.frame_placer.wrong_machine").withStyle(ChatFormatting.RED), true);
            }
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(handIn));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltip, @NotNull TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.frame_placer").withStyle(ChatFormatting.ITALIC));
    }
}

