/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.mixin;

import com.lumengrid.oritechthings.api.MagneticFieldController;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;

@Mixin(value={AcceleratorControllerBlockEntity.class})
public class AcceleratorControllerBlockEntityMixin
implements MagneticFieldController {
    private final List<BlockPos> linkedMagneticFields = new ArrayList<BlockPos>();

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void saveMagneticFields(CompoundTag nbt, HolderLookup.Provider registryLookup, CallbackInfo ci) {
        ListTag magneticFieldsTag = new ListTag();
        for (BlockPos pos : this.linkedMagneticFields) {
            CompoundTag posTag = new CompoundTag();
            posTag.putInt("x", pos.getX());
            posTag.putInt("y", pos.getY());
            posTag.putInt("z", pos.getZ());
            magneticFieldsTag.add((Object)posTag);
        }
        nbt.put("linkedMagneticFields", (Tag)magneticFieldsTag);
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    private void loadMagneticFields(CompoundTag nbt, HolderLookup.Provider registryLookup, CallbackInfo ci) {
        this.linkedMagneticFields.clear();
        if (nbt.contains("linkedMagneticFields", 9)) {
            ListTag magneticFieldsTag = nbt.getList("linkedMagneticFields", 10);
            for (int i = 0; i < magneticFieldsTag.size(); ++i) {
                CompoundTag posTag = magneticFieldsTag.getCompound(i);
                BlockPos pos = new BlockPos(posTag.getInt("x"), posTag.getInt("y"), posTag.getInt("z"));
                this.linkedMagneticFields.add(pos);
            }
        }
    }

    @Override
    public void addMagneticField(BlockPos magnetPos) {
        this.linkedMagneticFields.clear();
        this.linkedMagneticFields.add(magnetPos);
    }

    @Override
    public boolean removeMagneticField(BlockPos magnetPos) {
        return this.linkedMagneticFields.remove(magnetPos);
    }

    @Override
    public List<BlockPos> getLinkedMagneticFields() {
        return this.linkedMagneticFields;
    }
}

